package software.amazon.awscdk.interfaces.cleanrooms;

/**
 * A reference to a ConfiguredTableAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cleanrooms.*;
 * ConfiguredTableAssociationReference configuredTableAssociationReference = ConfiguredTableAssociationReference.builder()
 *         .configuredTableAssociationArn("configuredTableAssociationArn")
 *         .configuredTableAssociationIdentifier("configuredTableAssociationIdentifier")
 *         .membershipIdentifier("membershipIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cleanrooms.ConfiguredTableAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ConfiguredTableAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfiguredTableAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConfiguredTableAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableAssociationArn();

    /**
     * The ConfiguredTableAssociationIdentifier of the ConfiguredTableAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableAssociationIdentifier();

    /**
     * The MembershipIdentifier of the ConfiguredTableAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * @return a {@link Builder} of {@link ConfiguredTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfiguredTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAssociationReference> {
        java.lang.String configuredTableAssociationArn;
        java.lang.String configuredTableAssociationIdentifier;
        java.lang.String membershipIdentifier;

        /**
         * Sets the value of {@link ConfiguredTableAssociationReference#getConfiguredTableAssociationArn}
         * @param configuredTableAssociationArn The ARN of the ConfiguredTableAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationArn(java.lang.String configuredTableAssociationArn) {
            this.configuredTableAssociationArn = configuredTableAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link ConfiguredTableAssociationReference#getConfiguredTableAssociationIdentifier}
         * @param configuredTableAssociationIdentifier The ConfiguredTableAssociationIdentifier of the ConfiguredTableAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableAssociationIdentifier(java.lang.String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ConfiguredTableAssociationReference#getMembershipIdentifier}
         * @param membershipIdentifier The MembershipIdentifier of the ConfiguredTableAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfiguredTableAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfiguredTableAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfiguredTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAssociationReference {
        private final java.lang.String configuredTableAssociationArn;
        private final java.lang.String configuredTableAssociationIdentifier;
        private final java.lang.String membershipIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuredTableAssociationArn = software.amazon.jsii.Kernel.get(this, "configuredTableAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuredTableAssociationIdentifier = software.amazon.jsii.Kernel.get(this, "configuredTableAssociationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuredTableAssociationArn = java.util.Objects.requireNonNull(builder.configuredTableAssociationArn, "configuredTableAssociationArn is required");
            this.configuredTableAssociationIdentifier = java.util.Objects.requireNonNull(builder.configuredTableAssociationIdentifier, "configuredTableAssociationIdentifier is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
        }

        @Override
        public final java.lang.String getConfiguredTableAssociationArn() {
            return this.configuredTableAssociationArn;
        }

        @Override
        public final java.lang.String getConfiguredTableAssociationIdentifier() {
            return this.configuredTableAssociationIdentifier;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuredTableAssociationArn", om.valueToTree(this.getConfiguredTableAssociationArn()));
            data.set("configuredTableAssociationIdentifier", om.valueToTree(this.getConfiguredTableAssociationIdentifier()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cleanrooms.ConfiguredTableAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfiguredTableAssociationReference.Jsii$Proxy that = (ConfiguredTableAssociationReference.Jsii$Proxy) o;

            if (!configuredTableAssociationArn.equals(that.configuredTableAssociationArn)) return false;
            if (!configuredTableAssociationIdentifier.equals(that.configuredTableAssociationIdentifier)) return false;
            return this.membershipIdentifier.equals(that.membershipIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.configuredTableAssociationArn.hashCode();
            result = 31 * result + (this.configuredTableAssociationIdentifier.hashCode());
            result = 31 * result + (this.membershipIdentifier.hashCode());
            return result;
        }
    }
}
