package software.amazon.awscdk.interfaces.cleanrooms;

/**
 * A reference to a ConfiguredTable resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cleanrooms.*;
 * ConfiguredTableReference configuredTableReference = ConfiguredTableReference.builder()
 *         .configuredTableArn("configuredTableArn")
 *         .configuredTableIdentifier("configuredTableIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cleanrooms.ConfiguredTableReference")
@software.amazon.jsii.Jsii.Proxy(ConfiguredTableReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfiguredTableReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConfiguredTable resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableArn();

    /**
     * The ConfiguredTableIdentifier of the ConfiguredTable resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguredTableIdentifier();

    /**
     * @return a {@link Builder} of {@link ConfiguredTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfiguredTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableReference> {
        java.lang.String configuredTableArn;
        java.lang.String configuredTableIdentifier;

        /**
         * Sets the value of {@link ConfiguredTableReference#getConfiguredTableArn}
         * @param configuredTableArn The ARN of the ConfiguredTable resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableArn(java.lang.String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
            return this;
        }

        /**
         * Sets the value of {@link ConfiguredTableReference#getConfiguredTableIdentifier}
         * @param configuredTableIdentifier The ConfiguredTableIdentifier of the ConfiguredTable resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuredTableIdentifier(java.lang.String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfiguredTableReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfiguredTableReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfiguredTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableReference {
        private final java.lang.String configuredTableArn;
        private final java.lang.String configuredTableIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuredTableArn = software.amazon.jsii.Kernel.get(this, "configuredTableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuredTableIdentifier = software.amazon.jsii.Kernel.get(this, "configuredTableIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuredTableArn = java.util.Objects.requireNonNull(builder.configuredTableArn, "configuredTableArn is required");
            this.configuredTableIdentifier = java.util.Objects.requireNonNull(builder.configuredTableIdentifier, "configuredTableIdentifier is required");
        }

        @Override
        public final java.lang.String getConfiguredTableArn() {
            return this.configuredTableArn;
        }

        @Override
        public final java.lang.String getConfiguredTableIdentifier() {
            return this.configuredTableIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuredTableArn", om.valueToTree(this.getConfiguredTableArn()));
            data.set("configuredTableIdentifier", om.valueToTree(this.getConfiguredTableIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cleanrooms.ConfiguredTableReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfiguredTableReference.Jsii$Proxy that = (ConfiguredTableReference.Jsii$Proxy) o;

            if (!configuredTableArn.equals(that.configuredTableArn)) return false;
            return this.configuredTableIdentifier.equals(that.configuredTableIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.configuredTableArn.hashCode();
            result = 31 * result + (this.configuredTableIdentifier.hashCode());
            return result;
        }
    }
}
