package software.amazon.awscdk.interfaces.cleanrooms;

/**
 * A reference to a IdNamespaceAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cleanrooms.*;
 * IdNamespaceAssociationReference idNamespaceAssociationReference = IdNamespaceAssociationReference.builder()
 *         .idNamespaceAssociationArn("idNamespaceAssociationArn")
 *         .idNamespaceAssociationIdentifier("idNamespaceAssociationIdentifier")
 *         .membershipIdentifier("membershipIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.187Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cleanrooms.IdNamespaceAssociationReference")
@software.amazon.jsii.Jsii.Proxy(IdNamespaceAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdNamespaceAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IdNamespaceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdNamespaceAssociationArn();

    /**
     * The IdNamespaceAssociationIdentifier of the IdNamespaceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdNamespaceAssociationIdentifier();

    /**
     * The MembershipIdentifier of the IdNamespaceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * @return a {@link Builder} of {@link IdNamespaceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdNamespaceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceAssociationReference> {
        java.lang.String idNamespaceAssociationArn;
        java.lang.String idNamespaceAssociationIdentifier;
        java.lang.String membershipIdentifier;

        /**
         * Sets the value of {@link IdNamespaceAssociationReference#getIdNamespaceAssociationArn}
         * @param idNamespaceAssociationArn The ARN of the IdNamespaceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idNamespaceAssociationArn(java.lang.String idNamespaceAssociationArn) {
            this.idNamespaceAssociationArn = idNamespaceAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link IdNamespaceAssociationReference#getIdNamespaceAssociationIdentifier}
         * @param idNamespaceAssociationIdentifier The IdNamespaceAssociationIdentifier of the IdNamespaceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idNamespaceAssociationIdentifier(java.lang.String idNamespaceAssociationIdentifier) {
            this.idNamespaceAssociationIdentifier = idNamespaceAssociationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link IdNamespaceAssociationReference#getMembershipIdentifier}
         * @param membershipIdentifier The MembershipIdentifier of the IdNamespaceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdNamespaceAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdNamespaceAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdNamespaceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceAssociationReference {
        private final java.lang.String idNamespaceAssociationArn;
        private final java.lang.String idNamespaceAssociationIdentifier;
        private final java.lang.String membershipIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.idNamespaceAssociationArn = software.amazon.jsii.Kernel.get(this, "idNamespaceAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idNamespaceAssociationIdentifier = software.amazon.jsii.Kernel.get(this, "idNamespaceAssociationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.idNamespaceAssociationArn = java.util.Objects.requireNonNull(builder.idNamespaceAssociationArn, "idNamespaceAssociationArn is required");
            this.idNamespaceAssociationIdentifier = java.util.Objects.requireNonNull(builder.idNamespaceAssociationIdentifier, "idNamespaceAssociationIdentifier is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
        }

        @Override
        public final java.lang.String getIdNamespaceAssociationArn() {
            return this.idNamespaceAssociationArn;
        }

        @Override
        public final java.lang.String getIdNamespaceAssociationIdentifier() {
            return this.idNamespaceAssociationIdentifier;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("idNamespaceAssociationArn", om.valueToTree(this.getIdNamespaceAssociationArn()));
            data.set("idNamespaceAssociationIdentifier", om.valueToTree(this.getIdNamespaceAssociationIdentifier()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cleanrooms.IdNamespaceAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdNamespaceAssociationReference.Jsii$Proxy that = (IdNamespaceAssociationReference.Jsii$Proxy) o;

            if (!idNamespaceAssociationArn.equals(that.idNamespaceAssociationArn)) return false;
            if (!idNamespaceAssociationIdentifier.equals(that.idNamespaceAssociationIdentifier)) return false;
            return this.membershipIdentifier.equals(that.membershipIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.idNamespaceAssociationArn.hashCode();
            result = 31 * result + (this.idNamespaceAssociationIdentifier.hashCode());
            result = 31 * result + (this.membershipIdentifier.hashCode());
            return result;
        }
    }
}
