package software.amazon.awscdk.interfaces.cleanrooms;

/**
 * A reference to a PrivacyBudgetTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cleanrooms.*;
 * PrivacyBudgetTemplateReference privacyBudgetTemplateReference = PrivacyBudgetTemplateReference.builder()
 *         .membershipIdentifier("membershipIdentifier")
 *         .privacyBudgetTemplateArn("privacyBudgetTemplateArn")
 *         .privacyBudgetTemplateIdentifier("privacyBudgetTemplateIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.188Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cleanrooms.PrivacyBudgetTemplateReference")
@software.amazon.jsii.Jsii.Proxy(PrivacyBudgetTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrivacyBudgetTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The MembershipIdentifier of the PrivacyBudgetTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * The ARN of the PrivacyBudgetTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrivacyBudgetTemplateArn();

    /**
     * The PrivacyBudgetTemplateIdentifier of the PrivacyBudgetTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrivacyBudgetTemplateIdentifier();

    /**
     * @return a {@link Builder} of {@link PrivacyBudgetTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrivacyBudgetTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrivacyBudgetTemplateReference> {
        java.lang.String membershipIdentifier;
        java.lang.String privacyBudgetTemplateArn;
        java.lang.String privacyBudgetTemplateIdentifier;

        /**
         * Sets the value of {@link PrivacyBudgetTemplateReference#getMembershipIdentifier}
         * @param membershipIdentifier The MembershipIdentifier of the PrivacyBudgetTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link PrivacyBudgetTemplateReference#getPrivacyBudgetTemplateArn}
         * @param privacyBudgetTemplateArn The ARN of the PrivacyBudgetTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privacyBudgetTemplateArn(java.lang.String privacyBudgetTemplateArn) {
            this.privacyBudgetTemplateArn = privacyBudgetTemplateArn;
            return this;
        }

        /**
         * Sets the value of {@link PrivacyBudgetTemplateReference#getPrivacyBudgetTemplateIdentifier}
         * @param privacyBudgetTemplateIdentifier The PrivacyBudgetTemplateIdentifier of the PrivacyBudgetTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privacyBudgetTemplateIdentifier(java.lang.String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrivacyBudgetTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrivacyBudgetTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrivacyBudgetTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivacyBudgetTemplateReference {
        private final java.lang.String membershipIdentifier;
        private final java.lang.String privacyBudgetTemplateArn;
        private final java.lang.String privacyBudgetTemplateIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privacyBudgetTemplateArn = software.amazon.jsii.Kernel.get(this, "privacyBudgetTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privacyBudgetTemplateIdentifier = software.amazon.jsii.Kernel.get(this, "privacyBudgetTemplateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
            this.privacyBudgetTemplateArn = java.util.Objects.requireNonNull(builder.privacyBudgetTemplateArn, "privacyBudgetTemplateArn is required");
            this.privacyBudgetTemplateIdentifier = java.util.Objects.requireNonNull(builder.privacyBudgetTemplateIdentifier, "privacyBudgetTemplateIdentifier is required");
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        public final java.lang.String getPrivacyBudgetTemplateArn() {
            return this.privacyBudgetTemplateArn;
        }

        @Override
        public final java.lang.String getPrivacyBudgetTemplateIdentifier() {
            return this.privacyBudgetTemplateIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));
            data.set("privacyBudgetTemplateArn", om.valueToTree(this.getPrivacyBudgetTemplateArn()));
            data.set("privacyBudgetTemplateIdentifier", om.valueToTree(this.getPrivacyBudgetTemplateIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cleanrooms.PrivacyBudgetTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrivacyBudgetTemplateReference.Jsii$Proxy that = (PrivacyBudgetTemplateReference.Jsii$Proxy) o;

            if (!membershipIdentifier.equals(that.membershipIdentifier)) return false;
            if (!privacyBudgetTemplateArn.equals(that.privacyBudgetTemplateArn)) return false;
            return this.privacyBudgetTemplateIdentifier.equals(that.privacyBudgetTemplateIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.membershipIdentifier.hashCode();
            result = 31 * result + (this.privacyBudgetTemplateArn.hashCode());
            result = 31 * result + (this.privacyBudgetTemplateIdentifier.hashCode());
            return result;
        }
    }
}
