package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a CloudFrontOriginAccessIdentity resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * CloudFrontOriginAccessIdentityReference cloudFrontOriginAccessIdentityReference = CloudFrontOriginAccessIdentityReference.builder()
 *         .cloudFrontOriginAccessIdentityId("cloudFrontOriginAccessIdentityId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.201Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.CloudFrontOriginAccessIdentityReference")
@software.amazon.jsii.Jsii.Proxy(CloudFrontOriginAccessIdentityReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFrontOriginAccessIdentityReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the CloudFrontOriginAccessIdentity resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCloudFrontOriginAccessIdentityId();

    /**
     * @return a {@link Builder} of {@link CloudFrontOriginAccessIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFrontOriginAccessIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFrontOriginAccessIdentityReference> {
        java.lang.String cloudFrontOriginAccessIdentityId;

        /**
         * Sets the value of {@link CloudFrontOriginAccessIdentityReference#getCloudFrontOriginAccessIdentityId}
         * @param cloudFrontOriginAccessIdentityId The Id of the CloudFrontOriginAccessIdentity resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFrontOriginAccessIdentityId(java.lang.String cloudFrontOriginAccessIdentityId) {
            this.cloudFrontOriginAccessIdentityId = cloudFrontOriginAccessIdentityId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFrontOriginAccessIdentityReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFrontOriginAccessIdentityReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFrontOriginAccessIdentityReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFrontOriginAccessIdentityReference {
        private final java.lang.String cloudFrontOriginAccessIdentityId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudFrontOriginAccessIdentityId = software.amazon.jsii.Kernel.get(this, "cloudFrontOriginAccessIdentityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudFrontOriginAccessIdentityId = java.util.Objects.requireNonNull(builder.cloudFrontOriginAccessIdentityId, "cloudFrontOriginAccessIdentityId is required");
        }

        @Override
        public final java.lang.String getCloudFrontOriginAccessIdentityId() {
            return this.cloudFrontOriginAccessIdentityId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudFrontOriginAccessIdentityId", om.valueToTree(this.getCloudFrontOriginAccessIdentityId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.CloudFrontOriginAccessIdentityReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFrontOriginAccessIdentityReference.Jsii$Proxy that = (CloudFrontOriginAccessIdentityReference.Jsii$Proxy) o;

            return this.cloudFrontOriginAccessIdentityId.equals(that.cloudFrontOriginAccessIdentityId);
        }

        @Override
        public final int hashCode() {
            int result = this.cloudFrontOriginAccessIdentityId.hashCode();
            return result;
        }
    }
}
