package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a ConnectionGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * ConnectionGroupReference connectionGroupReference = ConnectionGroupReference.builder()
 *         .connectionGroupArn("connectionGroupArn")
 *         .connectionGroupId("connectionGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.202Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.ConnectionGroupReference")
@software.amazon.jsii.Jsii.Proxy(ConnectionGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConnectionGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionGroupArn();

    /**
     * The Id of the ConnectionGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionGroupId();

    /**
     * @return a {@link Builder} of {@link ConnectionGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionGroupReference> {
        java.lang.String connectionGroupArn;
        java.lang.String connectionGroupId;

        /**
         * Sets the value of {@link ConnectionGroupReference#getConnectionGroupArn}
         * @param connectionGroupArn The ARN of the ConnectionGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionGroupArn(java.lang.String connectionGroupArn) {
            this.connectionGroupArn = connectionGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionGroupReference#getConnectionGroupId}
         * @param connectionGroupId The Id of the ConnectionGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionGroupId(java.lang.String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectionGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionGroupReference {
        private final java.lang.String connectionGroupArn;
        private final java.lang.String connectionGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionGroupArn = software.amazon.jsii.Kernel.get(this, "connectionGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionGroupId = software.amazon.jsii.Kernel.get(this, "connectionGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionGroupArn = java.util.Objects.requireNonNull(builder.connectionGroupArn, "connectionGroupArn is required");
            this.connectionGroupId = java.util.Objects.requireNonNull(builder.connectionGroupId, "connectionGroupId is required");
        }

        @Override
        public final java.lang.String getConnectionGroupArn() {
            return this.connectionGroupArn;
        }

        @Override
        public final java.lang.String getConnectionGroupId() {
            return this.connectionGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionGroupArn", om.valueToTree(this.getConnectionGroupArn()));
            data.set("connectionGroupId", om.valueToTree(this.getConnectionGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.ConnectionGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionGroupReference.Jsii$Proxy that = (ConnectionGroupReference.Jsii$Proxy) o;

            if (!connectionGroupArn.equals(that.connectionGroupArn)) return false;
            return this.connectionGroupId.equals(that.connectionGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.connectionGroupArn.hashCode();
            result = 31 * result + (this.connectionGroupId.hashCode());
            return result;
        }
    }
}
