package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a VpcOrigin resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * VpcOriginReference vpcOriginReference = VpcOriginReference.builder()
 *         .vpcOriginArn("vpcOriginArn")
 *         .vpcOriginId("vpcOriginId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.VpcOriginReference")
@software.amazon.jsii.Jsii.Proxy(VpcOriginReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcOriginReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the VpcOrigin resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcOriginArn();

    /**
     * The Id of the VpcOrigin resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcOriginId();

    /**
     * @return a {@link Builder} of {@link VpcOriginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcOriginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcOriginReference> {
        java.lang.String vpcOriginArn;
        java.lang.String vpcOriginId;

        /**
         * Sets the value of {@link VpcOriginReference#getVpcOriginArn}
         * @param vpcOriginArn The ARN of the VpcOrigin resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginArn(java.lang.String vpcOriginArn) {
            this.vpcOriginArn = vpcOriginArn;
            return this;
        }

        /**
         * Sets the value of {@link VpcOriginReference#getVpcOriginId}
         * @param vpcOriginId The Id of the VpcOrigin resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOriginId(java.lang.String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcOriginReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcOriginReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcOriginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOriginReference {
        private final java.lang.String vpcOriginArn;
        private final java.lang.String vpcOriginId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcOriginArn = software.amazon.jsii.Kernel.get(this, "vpcOriginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcOriginId = software.amazon.jsii.Kernel.get(this, "vpcOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcOriginArn = java.util.Objects.requireNonNull(builder.vpcOriginArn, "vpcOriginArn is required");
            this.vpcOriginId = java.util.Objects.requireNonNull(builder.vpcOriginId, "vpcOriginId is required");
        }

        @Override
        public final java.lang.String getVpcOriginArn() {
            return this.vpcOriginArn;
        }

        @Override
        public final java.lang.String getVpcOriginId() {
            return this.vpcOriginId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcOriginArn", om.valueToTree(this.getVpcOriginArn()));
            data.set("vpcOriginId", om.valueToTree(this.getVpcOriginId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.VpcOriginReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcOriginReference.Jsii$Proxy that = (VpcOriginReference.Jsii$Proxy) o;

            if (!vpcOriginArn.equals(that.vpcOriginArn)) return false;
            return this.vpcOriginId.equals(that.vpcOriginId);
        }

        @Override
        public final int hashCode() {
            int result = this.vpcOriginArn.hashCode();
            result = 31 * result + (this.vpcOriginId.hashCode());
            return result;
        }
    }
}
