package software.amazon.awscdk.interfaces.cloudwatch;

/**
 * A reference to a CompositeAlarm resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudwatch.*;
 * CompositeAlarmReference compositeAlarmReference = CompositeAlarmReference.builder()
 *         .alarmName("alarmName")
 *         .compositeAlarmArn("compositeAlarmArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudwatch.CompositeAlarmReference")
@software.amazon.jsii.Jsii.Proxy(CompositeAlarmReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CompositeAlarmReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AlarmName of the CompositeAlarm resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

    /**
     * The ARN of the CompositeAlarm resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCompositeAlarmArn();

    /**
     * @return a {@link Builder} of {@link CompositeAlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CompositeAlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CompositeAlarmReference> {
        java.lang.String alarmName;
        java.lang.String compositeAlarmArn;

        /**
         * Sets the value of {@link CompositeAlarmReference#getAlarmName}
         * @param alarmName The AlarmName of the CompositeAlarm resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmReference#getCompositeAlarmArn}
         * @param compositeAlarmArn The ARN of the CompositeAlarm resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeAlarmArn(java.lang.String compositeAlarmArn) {
            this.compositeAlarmArn = compositeAlarmArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CompositeAlarmReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CompositeAlarmReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CompositeAlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeAlarmReference {
        private final java.lang.String alarmName;
        private final java.lang.String compositeAlarmArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compositeAlarmArn = software.amazon.jsii.Kernel.get(this, "compositeAlarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
            this.compositeAlarmArn = java.util.Objects.requireNonNull(builder.compositeAlarmArn, "compositeAlarmArn is required");
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final java.lang.String getCompositeAlarmArn() {
            return this.compositeAlarmArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmName", om.valueToTree(this.getAlarmName()));
            data.set("compositeAlarmArn", om.valueToTree(this.getCompositeAlarmArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudwatch.CompositeAlarmReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CompositeAlarmReference.Jsii$Proxy that = (CompositeAlarmReference.Jsii$Proxy) o;

            if (!alarmName.equals(that.alarmName)) return false;
            return this.compositeAlarmArn.equals(that.compositeAlarmArn);
        }

        @Override
        public final int hashCode() {
            int result = this.alarmName.hashCode();
            result = 31 * result + (this.compositeAlarmArn.hashCode());
            return result;
        }
    }
}
