package software.amazon.awscdk.interfaces.codebuild;

/**
 * A reference to a Project resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.codebuild.*;
 * ProjectReference projectReference = ProjectReference.builder()
 *         .projectArn("projectArn")
 *         .projectId("projectId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_codebuild.ProjectReference")
@software.amazon.jsii.Jsii.Proxy(ProjectReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProjectReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Project resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectArn();

    /**
     * The Id of the Project resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectId();

    /**
     * @return a {@link Builder} of {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProjectReference> {
        java.lang.String projectArn;
        java.lang.String projectId;

        /**
         * Sets the value of {@link ProjectReference#getProjectArn}
         * @param projectArn The ARN of the Project resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectArn(java.lang.String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        /**
         * Sets the value of {@link ProjectReference#getProjectId}
         * @param projectId The Id of the Project resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProjectReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectReference {
        private final java.lang.String projectArn;
        private final java.lang.String projectId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.projectArn = software.amazon.jsii.Kernel.get(this, "projectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectId = software.amazon.jsii.Kernel.get(this, "projectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.projectArn = java.util.Objects.requireNonNull(builder.projectArn, "projectArn is required");
            this.projectId = java.util.Objects.requireNonNull(builder.projectId, "projectId is required");
        }

        @Override
        public final java.lang.String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final java.lang.String getProjectId() {
            return this.projectId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("projectArn", om.valueToTree(this.getProjectArn()));
            data.set("projectId", om.valueToTree(this.getProjectId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_codebuild.ProjectReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProjectReference.Jsii$Proxy that = (ProjectReference.Jsii$Proxy) o;

            if (!projectArn.equals(that.projectArn)) return false;
            return this.projectId.equals(that.projectId);
        }

        @Override
        public final int hashCode() {
            int result = this.projectArn.hashCode();
            result = 31 * result + (this.projectId.hashCode());
            return result;
        }
    }
}
