package software.amazon.awscdk.interfaces.codebuild;

/**
 * A reference to a ReportGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.codebuild.*;
 * ReportGroupReference reportGroupReference = ReportGroupReference.builder()
 *         .reportGroupArn("reportGroupArn")
 *         .reportGroupId("reportGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_codebuild.ReportGroupReference")
@software.amazon.jsii.Jsii.Proxy(ReportGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReportGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ReportGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReportGroupArn();

    /**
     * The Id of the ReportGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReportGroupId();

    /**
     * @return a {@link Builder} of {@link ReportGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReportGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReportGroupReference> {
        java.lang.String reportGroupArn;
        java.lang.String reportGroupId;

        /**
         * Sets the value of {@link ReportGroupReference#getReportGroupArn}
         * @param reportGroupArn The ARN of the ReportGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportGroupArn(java.lang.String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link ReportGroupReference#getReportGroupId}
         * @param reportGroupId The Id of the ReportGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportGroupId(java.lang.String reportGroupId) {
            this.reportGroupId = reportGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReportGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReportGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReportGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportGroupReference {
        private final java.lang.String reportGroupArn;
        private final java.lang.String reportGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.reportGroupArn = software.amazon.jsii.Kernel.get(this, "reportGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reportGroupId = software.amazon.jsii.Kernel.get(this, "reportGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.reportGroupArn = java.util.Objects.requireNonNull(builder.reportGroupArn, "reportGroupArn is required");
            this.reportGroupId = java.util.Objects.requireNonNull(builder.reportGroupId, "reportGroupId is required");
        }

        @Override
        public final java.lang.String getReportGroupArn() {
            return this.reportGroupArn;
        }

        @Override
        public final java.lang.String getReportGroupId() {
            return this.reportGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("reportGroupArn", om.valueToTree(this.getReportGroupArn()));
            data.set("reportGroupId", om.valueToTree(this.getReportGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_codebuild.ReportGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReportGroupReference.Jsii$Proxy that = (ReportGroupReference.Jsii$Proxy) o;

            if (!reportGroupArn.equals(that.reportGroupArn)) return false;
            return this.reportGroupId.equals(that.reportGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.reportGroupArn.hashCode();
            result = 31 * result + (this.reportGroupId.hashCode());
            return result;
        }
    }
}
