package software.amazon.awscdk.interfaces.codestarconnections;

/**
 * A reference to a SyncConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.codestarconnections.*;
 * SyncConfigurationReference syncConfigurationReference = SyncConfigurationReference.builder()
 *         .resourceName("resourceName")
 *         .syncType("syncType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_codestarconnections.SyncConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(SyncConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SyncConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ResourceName of the SyncConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceName();

    /**
     * The SyncType of the SyncConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSyncType();

    /**
     * @return a {@link Builder} of {@link SyncConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SyncConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SyncConfigurationReference> {
        java.lang.String resourceName;
        java.lang.String syncType;

        /**
         * Sets the value of {@link SyncConfigurationReference#getResourceName}
         * @param resourceName The ResourceName of the SyncConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceName(java.lang.String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        /**
         * Sets the value of {@link SyncConfigurationReference#getSyncType}
         * @param syncType The SyncType of the SyncConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncType(java.lang.String syncType) {
            this.syncType = syncType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SyncConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SyncConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SyncConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SyncConfigurationReference {
        private final java.lang.String resourceName;
        private final java.lang.String syncType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceName = software.amazon.jsii.Kernel.get(this, "resourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.syncType = software.amazon.jsii.Kernel.get(this, "syncType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceName = java.util.Objects.requireNonNull(builder.resourceName, "resourceName is required");
            this.syncType = java.util.Objects.requireNonNull(builder.syncType, "syncType is required");
        }

        @Override
        public final java.lang.String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final java.lang.String getSyncType() {
            return this.syncType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceName", om.valueToTree(this.getResourceName()));
            data.set("syncType", om.valueToTree(this.getSyncType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_codestarconnections.SyncConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SyncConfigurationReference.Jsii$Proxy that = (SyncConfigurationReference.Jsii$Proxy) o;

            if (!resourceName.equals(that.resourceName)) return false;
            return this.syncType.equals(that.syncType);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceName.hashCode();
            result = 31 * result + (this.syncType.hashCode());
            return result;
        }
    }
}
