package software.amazon.awscdk.interfaces.config;

/**
 * A reference to a ConfigurationAggregator resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.config.*;
 * ConfigurationAggregatorReference configurationAggregatorReference = ConfigurationAggregatorReference.builder()
 *         .configurationAggregatorArn("configurationAggregatorArn")
 *         .configurationAggregatorName("configurationAggregatorName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.271Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_config.ConfigurationAggregatorReference")
@software.amazon.jsii.Jsii.Proxy(ConfigurationAggregatorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigurationAggregatorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConfigurationAggregator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigurationAggregatorArn();

    /**
     * The ConfigurationAggregatorName of the ConfigurationAggregator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigurationAggregatorName();

    /**
     * @return a {@link Builder} of {@link ConfigurationAggregatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigurationAggregatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigurationAggregatorReference> {
        java.lang.String configurationAggregatorArn;
        java.lang.String configurationAggregatorName;

        /**
         * Sets the value of {@link ConfigurationAggregatorReference#getConfigurationAggregatorArn}
         * @param configurationAggregatorArn The ARN of the ConfigurationAggregator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAggregatorArn(java.lang.String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationAggregatorReference#getConfigurationAggregatorName}
         * @param configurationAggregatorName The ConfigurationAggregatorName of the ConfigurationAggregator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAggregatorName(java.lang.String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigurationAggregatorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigurationAggregatorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigurationAggregatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationAggregatorReference {
        private final java.lang.String configurationAggregatorArn;
        private final java.lang.String configurationAggregatorName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationAggregatorArn = software.amazon.jsii.Kernel.get(this, "configurationAggregatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationAggregatorName = software.amazon.jsii.Kernel.get(this, "configurationAggregatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationAggregatorArn = java.util.Objects.requireNonNull(builder.configurationAggregatorArn, "configurationAggregatorArn is required");
            this.configurationAggregatorName = java.util.Objects.requireNonNull(builder.configurationAggregatorName, "configurationAggregatorName is required");
        }

        @Override
        public final java.lang.String getConfigurationAggregatorArn() {
            return this.configurationAggregatorArn;
        }

        @Override
        public final java.lang.String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationAggregatorArn", om.valueToTree(this.getConfigurationAggregatorArn()));
            data.set("configurationAggregatorName", om.valueToTree(this.getConfigurationAggregatorName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_config.ConfigurationAggregatorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigurationAggregatorReference.Jsii$Proxy that = (ConfigurationAggregatorReference.Jsii$Proxy) o;

            if (!configurationAggregatorArn.equals(that.configurationAggregatorArn)) return false;
            return this.configurationAggregatorName.equals(that.configurationAggregatorName);
        }

        @Override
        public final int hashCode() {
            int result = this.configurationAggregatorArn.hashCode();
            result = 31 * result + (this.configurationAggregatorName.hashCode());
            return result;
        }
    }
}
