package software.amazon.awscdk.interfaces.connect;

/**
 * A reference to a TaskTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.connect.*;
 * TaskTemplateReference taskTemplateReference = TaskTemplateReference.builder()
 *         .taskTemplateArn("taskTemplateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_connect.TaskTemplateReference")
@software.amazon.jsii.Jsii.Proxy(TaskTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TaskTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the TaskTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTaskTemplateArn();

    /**
     * @return a {@link Builder} of {@link TaskTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TaskTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TaskTemplateReference> {
        java.lang.String taskTemplateArn;

        /**
         * Sets the value of {@link TaskTemplateReference#getTaskTemplateArn}
         * @param taskTemplateArn The Arn of the TaskTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTemplateArn(java.lang.String taskTemplateArn) {
            this.taskTemplateArn = taskTemplateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TaskTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TaskTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskTemplateReference {
        private final java.lang.String taskTemplateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskTemplateArn = software.amazon.jsii.Kernel.get(this, "taskTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskTemplateArn = java.util.Objects.requireNonNull(builder.taskTemplateArn, "taskTemplateArn is required");
        }

        @Override
        public final java.lang.String getTaskTemplateArn() {
            return this.taskTemplateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskTemplateArn", om.valueToTree(this.getTaskTemplateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_connect.TaskTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TaskTemplateReference.Jsii$Proxy that = (TaskTemplateReference.Jsii$Proxy) o;

            return this.taskTemplateArn.equals(that.taskTemplateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.taskTemplateArn.hashCode();
            return result;
        }
    }
}
