package software.amazon.awscdk.interfaces.customerprofiles;

/**
 * A reference to a SegmentDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.customerprofiles.*;
 * SegmentDefinitionReference segmentDefinitionReference = SegmentDefinitionReference.builder()
 *         .domainName("domainName")
 *         .segmentDefinitionArn("segmentDefinitionArn")
 *         .segmentDefinitionName("segmentDefinitionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.314Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_customerprofiles.SegmentDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(SegmentDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SegmentDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DomainName of the SegmentDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The ARN of the SegmentDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentDefinitionArn();

    /**
     * The SegmentDefinitionName of the SegmentDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentDefinitionName();

    /**
     * @return a {@link Builder} of {@link SegmentDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SegmentDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SegmentDefinitionReference> {
        java.lang.String domainName;
        java.lang.String segmentDefinitionArn;
        java.lang.String segmentDefinitionName;

        /**
         * Sets the value of {@link SegmentDefinitionReference#getDomainName}
         * @param domainName The DomainName of the SegmentDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link SegmentDefinitionReference#getSegmentDefinitionArn}
         * @param segmentDefinitionArn The ARN of the SegmentDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDefinitionArn(java.lang.String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link SegmentDefinitionReference#getSegmentDefinitionName}
         * @param segmentDefinitionName The SegmentDefinitionName of the SegmentDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDefinitionName(java.lang.String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SegmentDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SegmentDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SegmentDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentDefinitionReference {
        private final java.lang.String domainName;
        private final java.lang.String segmentDefinitionArn;
        private final java.lang.String segmentDefinitionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.segmentDefinitionArn = software.amazon.jsii.Kernel.get(this, "segmentDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.segmentDefinitionName = software.amazon.jsii.Kernel.get(this, "segmentDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.segmentDefinitionArn = java.util.Objects.requireNonNull(builder.segmentDefinitionArn, "segmentDefinitionArn is required");
            this.segmentDefinitionName = java.util.Objects.requireNonNull(builder.segmentDefinitionName, "segmentDefinitionName is required");
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getSegmentDefinitionArn() {
            return this.segmentDefinitionArn;
        }

        @Override
        public final java.lang.String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("segmentDefinitionArn", om.valueToTree(this.getSegmentDefinitionArn()));
            data.set("segmentDefinitionName", om.valueToTree(this.getSegmentDefinitionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_customerprofiles.SegmentDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SegmentDefinitionReference.Jsii$Proxy that = (SegmentDefinitionReference.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!segmentDefinitionArn.equals(that.segmentDefinitionArn)) return false;
            return this.segmentDefinitionName.equals(that.segmentDefinitionName);
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.segmentDefinitionArn.hashCode());
            result = 31 * result + (this.segmentDefinitionName.hashCode());
            return result;
        }
    }
}
