package software.amazon.awscdk.interfaces.datazone;

/**
 * A reference to a ProjectProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.datazone.*;
 * ProjectProfileReference projectProfileReference = ProjectProfileReference.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .identifier("identifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.348Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_datazone.ProjectProfileReference")
@software.amazon.jsii.Jsii.Proxy(ProjectProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProjectProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DomainIdentifier of the ProjectProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The Identifier of the ProjectProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

    /**
     * @return a {@link Builder} of {@link ProjectProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProjectProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProjectProfileReference> {
        java.lang.String domainIdentifier;
        java.lang.String identifier;

        /**
         * Sets the value of {@link ProjectProfileReference#getDomainIdentifier}
         * @param domainIdentifier The DomainIdentifier of the ProjectProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ProjectProfileReference#getIdentifier}
         * @param identifier The Identifier of the ProjectProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProjectProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProjectProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectProfileReference {
        private final java.lang.String domainIdentifier;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("identifier", om.valueToTree(this.getIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_datazone.ProjectProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProjectProfileReference.Jsii$Proxy that = (ProjectProfileReference.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            return this.identifier.equals(that.identifier);
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.identifier.hashCode());
            return result;
        }
    }
}
