package software.amazon.awscdk.interfaces.deadline;

/**
 * A reference to a QueueLimitAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.deadline.*;
 * QueueLimitAssociationReference queueLimitAssociationReference = QueueLimitAssociationReference.builder()
 *         .farmId("farmId")
 *         .limitId("limitId")
 *         .queueId("queueId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_deadline.QueueLimitAssociationReference")
@software.amazon.jsii.Jsii.Proxy(QueueLimitAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueLimitAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The FarmId of the QueueLimitAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFarmId();

    /**
     * The LimitId of the QueueLimitAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLimitId();

    /**
     * The QueueId of the QueueLimitAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueId();

    /**
     * @return a {@link Builder} of {@link QueueLimitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueLimitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueLimitAssociationReference> {
        java.lang.String farmId;
        java.lang.String limitId;
        java.lang.String queueId;

        /**
         * Sets the value of {@link QueueLimitAssociationReference#getFarmId}
         * @param farmId The FarmId of the QueueLimitAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link QueueLimitAssociationReference#getLimitId}
         * @param limitId The LimitId of the QueueLimitAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limitId(java.lang.String limitId) {
            this.limitId = limitId;
            return this;
        }

        /**
         * Sets the value of {@link QueueLimitAssociationReference#getQueueId}
         * @param queueId The QueueId of the QueueLimitAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueId(java.lang.String queueId) {
            this.queueId = queueId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueLimitAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueLimitAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueueLimitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueLimitAssociationReference {
        private final java.lang.String farmId;
        private final java.lang.String limitId;
        private final java.lang.String queueId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.limitId = software.amazon.jsii.Kernel.get(this, "limitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueId = software.amazon.jsii.Kernel.get(this, "queueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.farmId = java.util.Objects.requireNonNull(builder.farmId, "farmId is required");
            this.limitId = java.util.Objects.requireNonNull(builder.limitId, "limitId is required");
            this.queueId = java.util.Objects.requireNonNull(builder.queueId, "queueId is required");
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.lang.String getLimitId() {
            return this.limitId;
        }

        @Override
        public final java.lang.String getQueueId() {
            return this.queueId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("farmId", om.valueToTree(this.getFarmId()));
            data.set("limitId", om.valueToTree(this.getLimitId()));
            data.set("queueId", om.valueToTree(this.getQueueId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_deadline.QueueLimitAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueLimitAssociationReference.Jsii$Proxy that = (QueueLimitAssociationReference.Jsii$Proxy) o;

            if (!farmId.equals(that.farmId)) return false;
            if (!limitId.equals(that.limitId)) return false;
            return this.queueId.equals(that.queueId);
        }

        @Override
        public final int hashCode() {
            int result = this.farmId.hashCode();
            result = 31 * result + (this.limitId.hashCode());
            result = 31 * result + (this.queueId.hashCode());
            return result;
        }
    }
}
