package software.amazon.awscdk.interfaces.devicefarm;

/**
 * A reference to a DevicePool resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.devicefarm.*;
 * DevicePoolReference devicePoolReference = DevicePoolReference.builder()
 *         .devicePoolArn("devicePoolArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.359Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_devicefarm.DevicePoolReference")
@software.amazon.jsii.Jsii.Proxy(DevicePoolReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DevicePoolReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the DevicePool resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDevicePoolArn();

    /**
     * @return a {@link Builder} of {@link DevicePoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DevicePoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DevicePoolReference> {
        java.lang.String devicePoolArn;

        /**
         * Sets the value of {@link DevicePoolReference#getDevicePoolArn}
         * @param devicePoolArn The Arn of the DevicePool resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder devicePoolArn(java.lang.String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DevicePoolReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DevicePoolReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DevicePoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DevicePoolReference {
        private final java.lang.String devicePoolArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.devicePoolArn = software.amazon.jsii.Kernel.get(this, "devicePoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.devicePoolArn = java.util.Objects.requireNonNull(builder.devicePoolArn, "devicePoolArn is required");
        }

        @Override
        public final java.lang.String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("devicePoolArn", om.valueToTree(this.getDevicePoolArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_devicefarm.DevicePoolReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DevicePoolReference.Jsii$Proxy that = (DevicePoolReference.Jsii$Proxy) o;

            return this.devicePoolArn.equals(that.devicePoolArn);
        }

        @Override
        public final int hashCode() {
            int result = this.devicePoolArn.hashCode();
            return result;
        }
    }
}
