package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a IPAM resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * IPAMReference iPAMReference = Map.of(
 *         "ipamArn", "ipamArn",
 *         "ipamId", "ipamId");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.422Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.IPAMReference")
@software.amazon.jsii.Jsii.Proxy(IPAMReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPAMReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IPAM resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamArn();

    /**
     * The IpamId of the IPAM resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamId();

    /**
     * @return a {@link Builder} of {@link IPAMReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IPAMReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IPAMReference> {
        java.lang.String ipamArn;
        java.lang.String ipamId;

        /**
         * Sets the value of {@link IPAMReference#getIpamArn}
         * @param ipamArn The ARN of the IPAM resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamArn(java.lang.String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        /**
         * Sets the value of {@link IPAMReference#getIpamId}
         * @param ipamId The IpamId of the IPAM resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamId(java.lang.String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IPAMReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IPAMReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IPAMReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPAMReference {
        private final java.lang.String ipamArn;
        private final java.lang.String ipamId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipamArn = software.amazon.jsii.Kernel.get(this, "ipamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamId = software.amazon.jsii.Kernel.get(this, "ipamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipamArn = java.util.Objects.requireNonNull(builder.ipamArn, "ipamArn is required");
            this.ipamId = java.util.Objects.requireNonNull(builder.ipamId, "ipamId is required");
        }

        @Override
        public final java.lang.String getIpamArn() {
            return this.ipamArn;
        }

        @Override
        public final java.lang.String getIpamId() {
            return this.ipamId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipamArn", om.valueToTree(this.getIpamArn()));
            data.set("ipamId", om.valueToTree(this.getIpamId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.IPAMReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IPAMReference.Jsii$Proxy that = (IPAMReference.Jsii$Proxy) o;

            if (!ipamArn.equals(that.ipamArn)) return false;
            return this.ipamId.equals(that.ipamId);
        }

        @Override
        public final int hashCode() {
            int result = this.ipamArn.hashCode();
            result = 31 * result + (this.ipamId.hashCode());
            return result;
        }
    }
}
