package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a IPAMResourceDiscoveryAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * IPAMResourceDiscoveryAssociationReference iPAMResourceDiscoveryAssociationReference = Map.of(
 *         "ipamResourceDiscoveryAssociationArn", "ipamResourceDiscoveryAssociationArn",
 *         "ipamResourceDiscoveryAssociationId", "ipamResourceDiscoveryAssociationId");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.422Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.IPAMResourceDiscoveryAssociationReference")
@software.amazon.jsii.Jsii.Proxy(IPAMResourceDiscoveryAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPAMResourceDiscoveryAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IPAMResourceDiscoveryAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamResourceDiscoveryAssociationArn();

    /**
     * The IpamResourceDiscoveryAssociationId of the IPAMResourceDiscoveryAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamResourceDiscoveryAssociationId();

    /**
     * @return a {@link Builder} of {@link IPAMResourceDiscoveryAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IPAMResourceDiscoveryAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IPAMResourceDiscoveryAssociationReference> {
        java.lang.String ipamResourceDiscoveryAssociationArn;
        java.lang.String ipamResourceDiscoveryAssociationId;

        /**
         * Sets the value of {@link IPAMResourceDiscoveryAssociationReference#getIpamResourceDiscoveryAssociationArn}
         * @param ipamResourceDiscoveryAssociationArn The ARN of the IPAMResourceDiscoveryAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamResourceDiscoveryAssociationArn(java.lang.String ipamResourceDiscoveryAssociationArn) {
            this.ipamResourceDiscoveryAssociationArn = ipamResourceDiscoveryAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link IPAMResourceDiscoveryAssociationReference#getIpamResourceDiscoveryAssociationId}
         * @param ipamResourceDiscoveryAssociationId The IpamResourceDiscoveryAssociationId of the IPAMResourceDiscoveryAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamResourceDiscoveryAssociationId(java.lang.String ipamResourceDiscoveryAssociationId) {
            this.ipamResourceDiscoveryAssociationId = ipamResourceDiscoveryAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IPAMResourceDiscoveryAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IPAMResourceDiscoveryAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IPAMResourceDiscoveryAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPAMResourceDiscoveryAssociationReference {
        private final java.lang.String ipamResourceDiscoveryAssociationArn;
        private final java.lang.String ipamResourceDiscoveryAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipamResourceDiscoveryAssociationArn = software.amazon.jsii.Kernel.get(this, "ipamResourceDiscoveryAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamResourceDiscoveryAssociationId = software.amazon.jsii.Kernel.get(this, "ipamResourceDiscoveryAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipamResourceDiscoveryAssociationArn = java.util.Objects.requireNonNull(builder.ipamResourceDiscoveryAssociationArn, "ipamResourceDiscoveryAssociationArn is required");
            this.ipamResourceDiscoveryAssociationId = java.util.Objects.requireNonNull(builder.ipamResourceDiscoveryAssociationId, "ipamResourceDiscoveryAssociationId is required");
        }

        @Override
        public final java.lang.String getIpamResourceDiscoveryAssociationArn() {
            return this.ipamResourceDiscoveryAssociationArn;
        }

        @Override
        public final java.lang.String getIpamResourceDiscoveryAssociationId() {
            return this.ipamResourceDiscoveryAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipamResourceDiscoveryAssociationArn", om.valueToTree(this.getIpamResourceDiscoveryAssociationArn()));
            data.set("ipamResourceDiscoveryAssociationId", om.valueToTree(this.getIpamResourceDiscoveryAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.IPAMResourceDiscoveryAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IPAMResourceDiscoveryAssociationReference.Jsii$Proxy that = (IPAMResourceDiscoveryAssociationReference.Jsii$Proxy) o;

            if (!ipamResourceDiscoveryAssociationArn.equals(that.ipamResourceDiscoveryAssociationArn)) return false;
            return this.ipamResourceDiscoveryAssociationId.equals(that.ipamResourceDiscoveryAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.ipamResourceDiscoveryAssociationArn.hashCode();
            result = 31 * result + (this.ipamResourceDiscoveryAssociationId.hashCode());
            return result;
        }
    }
}
