package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a LocalGatewayRoute resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * LocalGatewayRouteReference localGatewayRouteReference = LocalGatewayRouteReference.builder()
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .localGatewayRouteTableId("localGatewayRouteTableId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.453Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.LocalGatewayRouteReference")
@software.amazon.jsii.Jsii.Proxy(LocalGatewayRouteReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LocalGatewayRouteReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DestinationCidrBlock of the LocalGatewayRoute resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationCidrBlock();

    /**
     * The LocalGatewayRouteTableId of the LocalGatewayRoute resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayRouteTableId();

    /**
     * @return a {@link Builder} of {@link LocalGatewayRouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LocalGatewayRouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LocalGatewayRouteReference> {
        java.lang.String destinationCidrBlock;
        java.lang.String localGatewayRouteTableId;

        /**
         * Sets the value of {@link LocalGatewayRouteReference#getDestinationCidrBlock}
         * @param destinationCidrBlock The DestinationCidrBlock of the LocalGatewayRoute resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link LocalGatewayRouteReference#getLocalGatewayRouteTableId}
         * @param localGatewayRouteTableId The LocalGatewayRouteTableId of the LocalGatewayRoute resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayRouteTableId(java.lang.String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LocalGatewayRouteReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LocalGatewayRouteReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LocalGatewayRouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalGatewayRouteReference {
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String localGatewayRouteTableId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationCidrBlock = software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayRouteTableId = software.amazon.jsii.Kernel.get(this, "localGatewayRouteTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationCidrBlock = java.util.Objects.requireNonNull(builder.destinationCidrBlock, "destinationCidrBlock is required");
            this.localGatewayRouteTableId = java.util.Objects.requireNonNull(builder.localGatewayRouteTableId, "localGatewayRouteTableId is required");
        }

        @Override
        public final java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final java.lang.String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            data.set("localGatewayRouteTableId", om.valueToTree(this.getLocalGatewayRouteTableId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.LocalGatewayRouteReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LocalGatewayRouteReference.Jsii$Proxy that = (LocalGatewayRouteReference.Jsii$Proxy) o;

            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            return this.localGatewayRouteTableId.equals(that.localGatewayRouteTableId);
        }

        @Override
        public final int hashCode() {
            int result = this.destinationCidrBlock.hashCode();
            result = 31 * result + (this.localGatewayRouteTableId.hashCode());
            return result;
        }
    }
}
