package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a LocalGatewayVirtualInterfaceGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * LocalGatewayVirtualInterfaceGroupReference localGatewayVirtualInterfaceGroupReference = LocalGatewayVirtualInterfaceGroupReference.builder()
 *         .localGatewayVirtualInterfaceGroupArn("localGatewayVirtualInterfaceGroupArn")
 *         .localGatewayVirtualInterfaceGroupId("localGatewayVirtualInterfaceGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.454Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.LocalGatewayVirtualInterfaceGroupReference")
@software.amazon.jsii.Jsii.Proxy(LocalGatewayVirtualInterfaceGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LocalGatewayVirtualInterfaceGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the LocalGatewayVirtualInterfaceGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayVirtualInterfaceGroupArn();

    /**
     * The LocalGatewayVirtualInterfaceGroupId of the LocalGatewayVirtualInterfaceGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayVirtualInterfaceGroupId();

    /**
     * @return a {@link Builder} of {@link LocalGatewayVirtualInterfaceGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LocalGatewayVirtualInterfaceGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LocalGatewayVirtualInterfaceGroupReference> {
        java.lang.String localGatewayVirtualInterfaceGroupArn;
        java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Sets the value of {@link LocalGatewayVirtualInterfaceGroupReference#getLocalGatewayVirtualInterfaceGroupArn}
         * @param localGatewayVirtualInterfaceGroupArn The ARN of the LocalGatewayVirtualInterfaceGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayVirtualInterfaceGroupArn(java.lang.String localGatewayVirtualInterfaceGroupArn) {
            this.localGatewayVirtualInterfaceGroupArn = localGatewayVirtualInterfaceGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link LocalGatewayVirtualInterfaceGroupReference#getLocalGatewayVirtualInterfaceGroupId}
         * @param localGatewayVirtualInterfaceGroupId The LocalGatewayVirtualInterfaceGroupId of the LocalGatewayVirtualInterfaceGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayVirtualInterfaceGroupId(java.lang.String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LocalGatewayVirtualInterfaceGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LocalGatewayVirtualInterfaceGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LocalGatewayVirtualInterfaceGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalGatewayVirtualInterfaceGroupReference {
        private final java.lang.String localGatewayVirtualInterfaceGroupArn;
        private final java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.localGatewayVirtualInterfaceGroupArn = software.amazon.jsii.Kernel.get(this, "localGatewayVirtualInterfaceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayVirtualInterfaceGroupId = software.amazon.jsii.Kernel.get(this, "localGatewayVirtualInterfaceGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.localGatewayVirtualInterfaceGroupArn = java.util.Objects.requireNonNull(builder.localGatewayVirtualInterfaceGroupArn, "localGatewayVirtualInterfaceGroupArn is required");
            this.localGatewayVirtualInterfaceGroupId = java.util.Objects.requireNonNull(builder.localGatewayVirtualInterfaceGroupId, "localGatewayVirtualInterfaceGroupId is required");
        }

        @Override
        public final java.lang.String getLocalGatewayVirtualInterfaceGroupArn() {
            return this.localGatewayVirtualInterfaceGroupArn;
        }

        @Override
        public final java.lang.String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("localGatewayVirtualInterfaceGroupArn", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupArn()));
            data.set("localGatewayVirtualInterfaceGroupId", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.LocalGatewayVirtualInterfaceGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LocalGatewayVirtualInterfaceGroupReference.Jsii$Proxy that = (LocalGatewayVirtualInterfaceGroupReference.Jsii$Proxy) o;

            if (!localGatewayVirtualInterfaceGroupArn.equals(that.localGatewayVirtualInterfaceGroupArn)) return false;
            return this.localGatewayVirtualInterfaceGroupId.equals(that.localGatewayVirtualInterfaceGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.localGatewayVirtualInterfaceGroupArn.hashCode();
            result = 31 * result + (this.localGatewayVirtualInterfaceGroupId.hashCode());
            return result;
        }
    }
}
