package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a NetworkInsightsAccessScope resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * NetworkInsightsAccessScopeReference networkInsightsAccessScopeReference = NetworkInsightsAccessScopeReference.builder()
 *         .networkInsightsAccessScopeArn("networkInsightsAccessScopeArn")
 *         .networkInsightsAccessScopeId("networkInsightsAccessScopeId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.456Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.NetworkInsightsAccessScopeReference")
@software.amazon.jsii.Jsii.Proxy(NetworkInsightsAccessScopeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkInsightsAccessScopeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the NetworkInsightsAccessScope resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAccessScopeArn();

    /**
     * The NetworkInsightsAccessScopeId of the NetworkInsightsAccessScope resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAccessScopeId();

    /**
     * @return a {@link Builder} of {@link NetworkInsightsAccessScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkInsightsAccessScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkInsightsAccessScopeReference> {
        java.lang.String networkInsightsAccessScopeArn;
        java.lang.String networkInsightsAccessScopeId;

        /**
         * Sets the value of {@link NetworkInsightsAccessScopeReference#getNetworkInsightsAccessScopeArn}
         * @param networkInsightsAccessScopeArn The ARN of the NetworkInsightsAccessScope resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAccessScopeArn(java.lang.String networkInsightsAccessScopeArn) {
            this.networkInsightsAccessScopeArn = networkInsightsAccessScopeArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkInsightsAccessScopeReference#getNetworkInsightsAccessScopeId}
         * @param networkInsightsAccessScopeId The NetworkInsightsAccessScopeId of the NetworkInsightsAccessScope resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAccessScopeId(java.lang.String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkInsightsAccessScopeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkInsightsAccessScopeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkInsightsAccessScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInsightsAccessScopeReference {
        private final java.lang.String networkInsightsAccessScopeArn;
        private final java.lang.String networkInsightsAccessScopeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInsightsAccessScopeArn = software.amazon.jsii.Kernel.get(this, "networkInsightsAccessScopeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInsightsAccessScopeId = software.amazon.jsii.Kernel.get(this, "networkInsightsAccessScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInsightsAccessScopeArn = java.util.Objects.requireNonNull(builder.networkInsightsAccessScopeArn, "networkInsightsAccessScopeArn is required");
            this.networkInsightsAccessScopeId = java.util.Objects.requireNonNull(builder.networkInsightsAccessScopeId, "networkInsightsAccessScopeId is required");
        }

        @Override
        public final java.lang.String getNetworkInsightsAccessScopeArn() {
            return this.networkInsightsAccessScopeArn;
        }

        @Override
        public final java.lang.String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInsightsAccessScopeArn", om.valueToTree(this.getNetworkInsightsAccessScopeArn()));
            data.set("networkInsightsAccessScopeId", om.valueToTree(this.getNetworkInsightsAccessScopeId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.NetworkInsightsAccessScopeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkInsightsAccessScopeReference.Jsii$Proxy that = (NetworkInsightsAccessScopeReference.Jsii$Proxy) o;

            if (!networkInsightsAccessScopeArn.equals(that.networkInsightsAccessScopeArn)) return false;
            return this.networkInsightsAccessScopeId.equals(that.networkInsightsAccessScopeId);
        }

        @Override
        public final int hashCode() {
            int result = this.networkInsightsAccessScopeArn.hashCode();
            result = 31 * result + (this.networkInsightsAccessScopeId.hashCode());
            return result;
        }
    }
}
