package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a RouteServerPeer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * RouteServerPeerReference routeServerPeerReference = RouteServerPeerReference.builder()
 *         .routeServerPeerArn("routeServerPeerArn")
 *         .routeServerPeerId("routeServerPeerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.460Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.RouteServerPeerReference")
@software.amazon.jsii.Jsii.Proxy(RouteServerPeerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteServerPeerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RouteServerPeer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerPeerArn();

    /**
     * The Id of the RouteServerPeer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerPeerId();

    /**
     * @return a {@link Builder} of {@link RouteServerPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteServerPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteServerPeerReference> {
        java.lang.String routeServerPeerArn;
        java.lang.String routeServerPeerId;

        /**
         * Sets the value of {@link RouteServerPeerReference#getRouteServerPeerArn}
         * @param routeServerPeerArn The ARN of the RouteServerPeer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerPeerArn(java.lang.String routeServerPeerArn) {
            this.routeServerPeerArn = routeServerPeerArn;
            return this;
        }

        /**
         * Sets the value of {@link RouteServerPeerReference#getRouteServerPeerId}
         * @param routeServerPeerId The Id of the RouteServerPeer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerPeerId(java.lang.String routeServerPeerId) {
            this.routeServerPeerId = routeServerPeerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteServerPeerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteServerPeerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteServerPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteServerPeerReference {
        private final java.lang.String routeServerPeerArn;
        private final java.lang.String routeServerPeerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeServerPeerArn = software.amazon.jsii.Kernel.get(this, "routeServerPeerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeServerPeerId = software.amazon.jsii.Kernel.get(this, "routeServerPeerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeServerPeerArn = java.util.Objects.requireNonNull(builder.routeServerPeerArn, "routeServerPeerArn is required");
            this.routeServerPeerId = java.util.Objects.requireNonNull(builder.routeServerPeerId, "routeServerPeerId is required");
        }

        @Override
        public final java.lang.String getRouteServerPeerArn() {
            return this.routeServerPeerArn;
        }

        @Override
        public final java.lang.String getRouteServerPeerId() {
            return this.routeServerPeerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeServerPeerArn", om.valueToTree(this.getRouteServerPeerArn()));
            data.set("routeServerPeerId", om.valueToTree(this.getRouteServerPeerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.RouteServerPeerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteServerPeerReference.Jsii$Proxy that = (RouteServerPeerReference.Jsii$Proxy) o;

            if (!routeServerPeerArn.equals(that.routeServerPeerArn)) return false;
            return this.routeServerPeerId.equals(that.routeServerPeerId);
        }

        @Override
        public final int hashCode() {
            int result = this.routeServerPeerArn.hashCode();
            result = 31 * result + (this.routeServerPeerId.hashCode());
            return result;
        }
    }
}
