package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a RouteServer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * RouteServerReference routeServerReference = RouteServerReference.builder()
 *         .routeServerArn("routeServerArn")
 *         .routeServerId("routeServerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.461Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.RouteServerReference")
@software.amazon.jsii.Jsii.Proxy(RouteServerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteServerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RouteServer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerArn();

    /**
     * The Id of the RouteServer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerId();

    /**
     * @return a {@link Builder} of {@link RouteServerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteServerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteServerReference> {
        java.lang.String routeServerArn;
        java.lang.String routeServerId;

        /**
         * Sets the value of {@link RouteServerReference#getRouteServerArn}
         * @param routeServerArn The ARN of the RouteServer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerArn(java.lang.String routeServerArn) {
            this.routeServerArn = routeServerArn;
            return this;
        }

        /**
         * Sets the value of {@link RouteServerReference#getRouteServerId}
         * @param routeServerId The Id of the RouteServer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerId(java.lang.String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteServerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteServerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteServerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteServerReference {
        private final java.lang.String routeServerArn;
        private final java.lang.String routeServerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeServerArn = software.amazon.jsii.Kernel.get(this, "routeServerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeServerId = software.amazon.jsii.Kernel.get(this, "routeServerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeServerArn = java.util.Objects.requireNonNull(builder.routeServerArn, "routeServerArn is required");
            this.routeServerId = java.util.Objects.requireNonNull(builder.routeServerId, "routeServerId is required");
        }

        @Override
        public final java.lang.String getRouteServerArn() {
            return this.routeServerArn;
        }

        @Override
        public final java.lang.String getRouteServerId() {
            return this.routeServerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeServerArn", om.valueToTree(this.getRouteServerArn()));
            data.set("routeServerId", om.valueToTree(this.getRouteServerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.RouteServerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteServerReference.Jsii$Proxy that = (RouteServerReference.Jsii$Proxy) o;

            if (!routeServerArn.equals(that.routeServerArn)) return false;
            return this.routeServerId.equals(that.routeServerId);
        }

        @Override
        public final int hashCode() {
            int result = this.routeServerArn.hashCode();
            result = 31 * result + (this.routeServerId.hashCode());
            return result;
        }
    }
}
