package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a SubnetRouteTableAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * SubnetRouteTableAssociationReference subnetRouteTableAssociationReference = SubnetRouteTableAssociationReference.builder()
 *         .subnetRouteTableAssociationId("subnetRouteTableAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.464Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.SubnetRouteTableAssociationReference")
@software.amazon.jsii.Jsii.Proxy(SubnetRouteTableAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetRouteTableAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the SubnetRouteTableAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetRouteTableAssociationId();

    /**
     * @return a {@link Builder} of {@link SubnetRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetRouteTableAssociationReference> {
        java.lang.String subnetRouteTableAssociationId;

        /**
         * Sets the value of {@link SubnetRouteTableAssociationReference#getSubnetRouteTableAssociationId}
         * @param subnetRouteTableAssociationId The Id of the SubnetRouteTableAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetRouteTableAssociationId(java.lang.String subnetRouteTableAssociationId) {
            this.subnetRouteTableAssociationId = subnetRouteTableAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetRouteTableAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetRouteTableAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetRouteTableAssociationReference {
        private final java.lang.String subnetRouteTableAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnetRouteTableAssociationId = software.amazon.jsii.Kernel.get(this, "subnetRouteTableAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetRouteTableAssociationId = java.util.Objects.requireNonNull(builder.subnetRouteTableAssociationId, "subnetRouteTableAssociationId is required");
        }

        @Override
        public final java.lang.String getSubnetRouteTableAssociationId() {
            return this.subnetRouteTableAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnetRouteTableAssociationId", om.valueToTree(this.getSubnetRouteTableAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.SubnetRouteTableAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetRouteTableAssociationReference.Jsii$Proxy that = (SubnetRouteTableAssociationReference.Jsii$Proxy) o;

            return this.subnetRouteTableAssociationId.equals(that.subnetRouteTableAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.subnetRouteTableAssociationId.hashCode();
            return result;
        }
    }
}
