package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a TransitGatewayMulticastGroupMember resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * TransitGatewayMulticastGroupMemberReference transitGatewayMulticastGroupMemberReference = TransitGatewayMulticastGroupMemberReference.builder()
 *         .groupIpAddress("groupIpAddress")
 *         .networkInterfaceId("networkInterfaceId")
 *         .transitGatewayMulticastDomainId("transitGatewayMulticastDomainId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.467Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.TransitGatewayMulticastGroupMemberReference")
@software.amazon.jsii.Jsii.Proxy(TransitGatewayMulticastGroupMemberReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransitGatewayMulticastGroupMemberReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GroupIpAddress of the TransitGatewayMulticastGroupMember resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupIpAddress();

    /**
     * The NetworkInterfaceId of the TransitGatewayMulticastGroupMember resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceId();

    /**
     * The TransitGatewayMulticastDomainId of the TransitGatewayMulticastGroupMember resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayMulticastDomainId();

    /**
     * @return a {@link Builder} of {@link TransitGatewayMulticastGroupMemberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransitGatewayMulticastGroupMemberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayMulticastGroupMemberReference> {
        java.lang.String groupIpAddress;
        java.lang.String networkInterfaceId;
        java.lang.String transitGatewayMulticastDomainId;

        /**
         * Sets the value of {@link TransitGatewayMulticastGroupMemberReference#getGroupIpAddress}
         * @param groupIpAddress The GroupIpAddress of the TransitGatewayMulticastGroupMember resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupIpAddress(java.lang.String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link TransitGatewayMulticastGroupMemberReference#getNetworkInterfaceId}
         * @param networkInterfaceId The NetworkInterfaceId of the TransitGatewayMulticastGroupMember resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link TransitGatewayMulticastGroupMemberReference#getTransitGatewayMulticastDomainId}
         * @param transitGatewayMulticastDomainId The TransitGatewayMulticastDomainId of the TransitGatewayMulticastGroupMember resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayMulticastDomainId(java.lang.String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransitGatewayMulticastGroupMemberReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransitGatewayMulticastGroupMemberReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransitGatewayMulticastGroupMemberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayMulticastGroupMemberReference {
        private final java.lang.String groupIpAddress;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String transitGatewayMulticastDomainId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupIpAddress = software.amazon.jsii.Kernel.get(this, "groupIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayMulticastDomainId = software.amazon.jsii.Kernel.get(this, "transitGatewayMulticastDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupIpAddress = java.util.Objects.requireNonNull(builder.groupIpAddress, "groupIpAddress is required");
            this.networkInterfaceId = java.util.Objects.requireNonNull(builder.networkInterfaceId, "networkInterfaceId is required");
            this.transitGatewayMulticastDomainId = java.util.Objects.requireNonNull(builder.transitGatewayMulticastDomainId, "transitGatewayMulticastDomainId is required");
        }

        @Override
        public final java.lang.String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        @Override
        public final java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final java.lang.String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupIpAddress", om.valueToTree(this.getGroupIpAddress()));
            data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            data.set("transitGatewayMulticastDomainId", om.valueToTree(this.getTransitGatewayMulticastDomainId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.TransitGatewayMulticastGroupMemberReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransitGatewayMulticastGroupMemberReference.Jsii$Proxy that = (TransitGatewayMulticastGroupMemberReference.Jsii$Proxy) o;

            if (!groupIpAddress.equals(that.groupIpAddress)) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            return this.transitGatewayMulticastDomainId.equals(that.transitGatewayMulticastDomainId);
        }

        @Override
        public final int hashCode() {
            int result = this.groupIpAddress.hashCode();
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.transitGatewayMulticastDomainId.hashCode());
            return result;
        }
    }
}
