package software.amazon.awscdk.interfaces.ecr;

/**
 * A reference to a PullThroughCacheRule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ecr.*;
 * PullThroughCacheRuleReference pullThroughCacheRuleReference = PullThroughCacheRuleReference.builder()
 *         .ecrRepositoryPrefix("ecrRepositoryPrefix")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.494Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ecr.PullThroughCacheRuleReference")
@software.amazon.jsii.Jsii.Proxy(PullThroughCacheRuleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PullThroughCacheRuleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EcrRepositoryPrefix of the PullThroughCacheRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEcrRepositoryPrefix();

    /**
     * @return a {@link Builder} of {@link PullThroughCacheRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PullThroughCacheRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PullThroughCacheRuleReference> {
        java.lang.String ecrRepositoryPrefix;

        /**
         * Sets the value of {@link PullThroughCacheRuleReference#getEcrRepositoryPrefix}
         * @param ecrRepositoryPrefix The EcrRepositoryPrefix of the PullThroughCacheRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecrRepositoryPrefix(java.lang.String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PullThroughCacheRuleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PullThroughCacheRuleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PullThroughCacheRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PullThroughCacheRuleReference {
        private final java.lang.String ecrRepositoryPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ecrRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "ecrRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ecrRepositoryPrefix = java.util.Objects.requireNonNull(builder.ecrRepositoryPrefix, "ecrRepositoryPrefix is required");
        }

        @Override
        public final java.lang.String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ecrRepositoryPrefix", om.valueToTree(this.getEcrRepositoryPrefix()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ecr.PullThroughCacheRuleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PullThroughCacheRuleReference.Jsii$Proxy that = (PullThroughCacheRuleReference.Jsii$Proxy) o;

            return this.ecrRepositoryPrefix.equals(that.ecrRepositoryPrefix);
        }

        @Override
        public final int hashCode() {
            int result = this.ecrRepositoryPrefix.hashCode();
            return result;
        }
    }
}
