package software.amazon.awscdk.interfaces.eks;

/**
 * A reference to a Addon resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.eks.*;
 * AddonReference addonReference = AddonReference.builder()
 *         .addonArn("addonArn")
 *         .addonName("addonName")
 *         .clusterName("clusterName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.503Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_eks.AddonReference")
@software.amazon.jsii.Jsii.Proxy(AddonReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddonReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Addon resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonArn();

    /**
     * The AddonName of the Addon resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonName();

    /**
     * The ClusterName of the Addon resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * @return a {@link Builder} of {@link AddonReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddonReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddonReference> {
        java.lang.String addonArn;
        java.lang.String addonName;
        java.lang.String clusterName;

        /**
         * Sets the value of {@link AddonReference#getAddonArn}
         * @param addonArn The ARN of the Addon resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonArn(java.lang.String addonArn) {
            this.addonArn = addonArn;
            return this;
        }

        /**
         * Sets the value of {@link AddonReference#getAddonName}
         * @param addonName The AddonName of the Addon resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonName(java.lang.String addonName) {
            this.addonName = addonName;
            return this;
        }

        /**
         * Sets the value of {@link AddonReference#getClusterName}
         * @param clusterName The ClusterName of the Addon resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddonReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddonReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddonReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddonReference {
        private final java.lang.String addonArn;
        private final java.lang.String addonName;
        private final java.lang.String clusterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addonArn = software.amazon.jsii.Kernel.get(this, "addonArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addonName = software.amazon.jsii.Kernel.get(this, "addonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addonArn = java.util.Objects.requireNonNull(builder.addonArn, "addonArn is required");
            this.addonName = java.util.Objects.requireNonNull(builder.addonName, "addonName is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
        }

        @Override
        public final java.lang.String getAddonArn() {
            return this.addonArn;
        }

        @Override
        public final java.lang.String getAddonName() {
            return this.addonName;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addonArn", om.valueToTree(this.getAddonArn()));
            data.set("addonName", om.valueToTree(this.getAddonName()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_eks.AddonReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddonReference.Jsii$Proxy that = (AddonReference.Jsii$Proxy) o;

            if (!addonArn.equals(that.addonArn)) return false;
            if (!addonName.equals(that.addonName)) return false;
            return this.clusterName.equals(that.clusterName);
        }

        @Override
        public final int hashCode() {
            int result = this.addonArn.hashCode();
            result = 31 * result + (this.addonName.hashCode());
            result = 31 * result + (this.clusterName.hashCode());
            return result;
        }
    }
}
