package software.amazon.awscdk.interfaces.eks;

/**
 * A reference to a IdentityProviderConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.eks.*;
 * IdentityProviderConfigReference identityProviderConfigReference = IdentityProviderConfigReference.builder()
 *         .clusterName("clusterName")
 *         .identityProviderConfigArn("identityProviderConfigArn")
 *         .identityProviderConfigName("identityProviderConfigName")
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_eks.IdentityProviderConfigReference")
@software.amazon.jsii.Jsii.Proxy(IdentityProviderConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentityProviderConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ClusterName of the IdentityProviderConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The ARN of the IdentityProviderConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderConfigArn();

    /**
     * The IdentityProviderConfigName of the IdentityProviderConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderConfigName();

    /**
     * The Type of the IdentityProviderConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * @return a {@link Builder} of {@link IdentityProviderConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityProviderConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderConfigReference> {
        java.lang.String clusterName;
        java.lang.String identityProviderConfigArn;
        java.lang.String identityProviderConfigName;
        java.lang.String type;

        /**
         * Sets the value of {@link IdentityProviderConfigReference#getClusterName}
         * @param clusterName The ClusterName of the IdentityProviderConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link IdentityProviderConfigReference#getIdentityProviderConfigArn}
         * @param identityProviderConfigArn The ARN of the IdentityProviderConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfigArn(java.lang.String identityProviderConfigArn) {
            this.identityProviderConfigArn = identityProviderConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link IdentityProviderConfigReference#getIdentityProviderConfigName}
         * @param identityProviderConfigName The IdentityProviderConfigName of the IdentityProviderConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfigName(java.lang.String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
            return this;
        }

        /**
         * Sets the value of {@link IdentityProviderConfigReference#getType}
         * @param type The Type of the IdentityProviderConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityProviderConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentityProviderConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityProviderConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderConfigReference {
        private final java.lang.String clusterName;
        private final java.lang.String identityProviderConfigArn;
        private final java.lang.String identityProviderConfigName;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderConfigArn = software.amazon.jsii.Kernel.get(this, "identityProviderConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderConfigName = software.amazon.jsii.Kernel.get(this, "identityProviderConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.identityProviderConfigArn = java.util.Objects.requireNonNull(builder.identityProviderConfigArn, "identityProviderConfigArn is required");
            this.identityProviderConfigName = java.util.Objects.requireNonNull(builder.identityProviderConfigName, "identityProviderConfigName is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getIdentityProviderConfigArn() {
            return this.identityProviderConfigArn;
        }

        @Override
        public final java.lang.String getIdentityProviderConfigName() {
            return this.identityProviderConfigName;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("identityProviderConfigArn", om.valueToTree(this.getIdentityProviderConfigArn()));
            data.set("identityProviderConfigName", om.valueToTree(this.getIdentityProviderConfigName()));
            data.set("type", om.valueToTree(this.getType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_eks.IdentityProviderConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityProviderConfigReference.Jsii$Proxy that = (IdentityProviderConfigReference.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!identityProviderConfigArn.equals(that.identityProviderConfigArn)) return false;
            if (!identityProviderConfigName.equals(that.identityProviderConfigName)) return false;
            return this.type.equals(that.type);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.identityProviderConfigArn.hashCode());
            result = 31 * result + (this.identityProviderConfigName.hashCode());
            result = 31 * result + (this.type.hashCode());
            return result;
        }
    }
}
