package software.amazon.awscdk.interfaces.eks;

/**
 * A reference to a Nodegroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.eks.*;
 * NodegroupReference nodegroupReference = NodegroupReference.builder()
 *         .nodegroupArn("nodegroupArn")
 *         .nodegroupId("nodegroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_eks.NodegroupReference")
@software.amazon.jsii.Jsii.Proxy(NodegroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NodegroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Nodegroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodegroupArn();

    /**
     * The Id of the Nodegroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodegroupId();

    /**
     * @return a {@link Builder} of {@link NodegroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NodegroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NodegroupReference> {
        java.lang.String nodegroupArn;
        java.lang.String nodegroupId;

        /**
         * Sets the value of {@link NodegroupReference#getNodegroupArn}
         * @param nodegroupArn The ARN of the Nodegroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodegroupArn(java.lang.String nodegroupArn) {
            this.nodegroupArn = nodegroupArn;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupReference#getNodegroupId}
         * @param nodegroupId The Id of the Nodegroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodegroupId(java.lang.String nodegroupId) {
            this.nodegroupId = nodegroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NodegroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NodegroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NodegroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodegroupReference {
        private final java.lang.String nodegroupArn;
        private final java.lang.String nodegroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.nodegroupArn = software.amazon.jsii.Kernel.get(this, "nodegroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodegroupId = software.amazon.jsii.Kernel.get(this, "nodegroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.nodegroupArn = java.util.Objects.requireNonNull(builder.nodegroupArn, "nodegroupArn is required");
            this.nodegroupId = java.util.Objects.requireNonNull(builder.nodegroupId, "nodegroupId is required");
        }

        @Override
        public final java.lang.String getNodegroupArn() {
            return this.nodegroupArn;
        }

        @Override
        public final java.lang.String getNodegroupId() {
            return this.nodegroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("nodegroupArn", om.valueToTree(this.getNodegroupArn()));
            data.set("nodegroupId", om.valueToTree(this.getNodegroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_eks.NodegroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NodegroupReference.Jsii$Proxy that = (NodegroupReference.Jsii$Proxy) o;

            if (!nodegroupArn.equals(that.nodegroupArn)) return false;
            return this.nodegroupId.equals(that.nodegroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.nodegroupArn.hashCode();
            result = 31 * result + (this.nodegroupId.hashCode());
            return result;
        }
    }
}
