package software.amazon.awscdk.interfaces.elasticache;

/**
 * A reference to a UserGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.elasticache.*;
 * UserGroupReference userGroupReference = UserGroupReference.builder()
 *         .userGroupArn("userGroupArn")
 *         .userGroupId("userGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.513Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_elasticache.UserGroupReference")
@software.amazon.jsii.Jsii.Proxy(UserGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the UserGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserGroupArn();

    /**
     * The UserGroupId of the UserGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserGroupId();

    /**
     * @return a {@link Builder} of {@link UserGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserGroupReference> {
        java.lang.String userGroupArn;
        java.lang.String userGroupId;

        /**
         * Sets the value of {@link UserGroupReference#getUserGroupArn}
         * @param userGroupArn The ARN of the UserGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupArn(java.lang.String userGroupArn) {
            this.userGroupArn = userGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link UserGroupReference#getUserGroupId}
         * @param userGroupId The UserGroupId of the UserGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupId(java.lang.String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserGroupReference {
        private final java.lang.String userGroupArn;
        private final java.lang.String userGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userGroupArn = software.amazon.jsii.Kernel.get(this, "userGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userGroupId = software.amazon.jsii.Kernel.get(this, "userGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userGroupArn = java.util.Objects.requireNonNull(builder.userGroupArn, "userGroupArn is required");
            this.userGroupId = java.util.Objects.requireNonNull(builder.userGroupId, "userGroupId is required");
        }

        @Override
        public final java.lang.String getUserGroupArn() {
            return this.userGroupArn;
        }

        @Override
        public final java.lang.String getUserGroupId() {
            return this.userGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userGroupArn", om.valueToTree(this.getUserGroupArn()));
            data.set("userGroupId", om.valueToTree(this.getUserGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_elasticache.UserGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserGroupReference.Jsii$Proxy that = (UserGroupReference.Jsii$Proxy) o;

            if (!userGroupArn.equals(that.userGroupArn)) return false;
            return this.userGroupId.equals(that.userGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.userGroupArn.hashCode();
            result = 31 * result + (this.userGroupId.hashCode());
            return result;
        }
    }
}
