package software.amazon.awscdk.interfaces.emr;

/**
 * A reference to a StudioSessionMapping resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.emr.*;
 * StudioSessionMappingReference studioSessionMappingReference = StudioSessionMappingReference.builder()
 *         .identityName("identityName")
 *         .identityType("identityType")
 *         .studioId("studioId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_emr.StudioSessionMappingReference")
@software.amazon.jsii.Jsii.Proxy(StudioSessionMappingReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StudioSessionMappingReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IdentityName of the StudioSessionMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityName();

    /**
     * The IdentityType of the StudioSessionMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityType();

    /**
     * The StudioId of the StudioSessionMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioId();

    /**
     * @return a {@link Builder} of {@link StudioSessionMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StudioSessionMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StudioSessionMappingReference> {
        java.lang.String identityName;
        java.lang.String identityType;
        java.lang.String studioId;

        /**
         * Sets the value of {@link StudioSessionMappingReference#getIdentityName}
         * @param identityName The IdentityName of the StudioSessionMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityName(java.lang.String identityName) {
            this.identityName = identityName;
            return this;
        }

        /**
         * Sets the value of {@link StudioSessionMappingReference#getIdentityType}
         * @param identityType The IdentityType of the StudioSessionMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityType(java.lang.String identityType) {
            this.identityType = identityType;
            return this;
        }

        /**
         * Sets the value of {@link StudioSessionMappingReference#getStudioId}
         * @param studioId The StudioId of the StudioSessionMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(java.lang.String studioId) {
            this.studioId = studioId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StudioSessionMappingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StudioSessionMappingReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StudioSessionMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StudioSessionMappingReference {
        private final java.lang.String identityName;
        private final java.lang.String identityType;
        private final java.lang.String studioId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityName = software.amazon.jsii.Kernel.get(this, "identityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityType = software.amazon.jsii.Kernel.get(this, "identityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioId = software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityName = java.util.Objects.requireNonNull(builder.identityName, "identityName is required");
            this.identityType = java.util.Objects.requireNonNull(builder.identityType, "identityType is required");
            this.studioId = java.util.Objects.requireNonNull(builder.studioId, "studioId is required");
        }

        @Override
        public final java.lang.String getIdentityName() {
            return this.identityName;
        }

        @Override
        public final java.lang.String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final java.lang.String getStudioId() {
            return this.studioId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityName", om.valueToTree(this.getIdentityName()));
            data.set("identityType", om.valueToTree(this.getIdentityType()));
            data.set("studioId", om.valueToTree(this.getStudioId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_emr.StudioSessionMappingReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StudioSessionMappingReference.Jsii$Proxy that = (StudioSessionMappingReference.Jsii$Proxy) o;

            if (!identityName.equals(that.identityName)) return false;
            if (!identityType.equals(that.identityType)) return false;
            return this.studioId.equals(that.studioId);
        }

        @Override
        public final int hashCode() {
            int result = this.identityName.hashCode();
            result = 31 * result + (this.identityType.hashCode());
            result = 31 * result + (this.studioId.hashCode());
            return result;
        }
    }
}
