package software.amazon.awscdk.interfaces.entityresolution;

/**
 * A reference to a SchemaMapping resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.entityresolution.*;
 * SchemaMappingReference schemaMappingReference = SchemaMappingReference.builder()
 *         .schemaName("schemaName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_entityresolution.SchemaMappingReference")
@software.amazon.jsii.Jsii.Proxy(SchemaMappingReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SchemaMappingReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The SchemaName of the SchemaMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaName();

    /**
     * @return a {@link Builder} of {@link SchemaMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SchemaMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SchemaMappingReference> {
        java.lang.String schemaName;

        /**
         * Sets the value of {@link SchemaMappingReference#getSchemaName}
         * @param schemaName The SchemaName of the SchemaMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaName(java.lang.String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SchemaMappingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SchemaMappingReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SchemaMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaMappingReference {
        private final java.lang.String schemaName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schemaName = software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schemaName = java.util.Objects.requireNonNull(builder.schemaName, "schemaName is required");
        }

        @Override
        public final java.lang.String getSchemaName() {
            return this.schemaName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schemaName", om.valueToTree(this.getSchemaName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_entityresolution.SchemaMappingReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SchemaMappingReference.Jsii$Proxy that = (SchemaMappingReference.Jsii$Proxy) o;

            return this.schemaName.equals(that.schemaName);
        }

        @Override
        public final int hashCode() {
            int result = this.schemaName.hashCode();
            return result;
        }
    }
}
