package software.amazon.awscdk.interfaces.fsx;

/**
 * A reference to a StorageVirtualMachine resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.fsx.*;
 * StorageVirtualMachineReference storageVirtualMachineReference = StorageVirtualMachineReference.builder()
 *         .storageVirtualMachineId("storageVirtualMachineId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_fsx.StorageVirtualMachineReference")
@software.amazon.jsii.Jsii.Proxy(StorageVirtualMachineReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StorageVirtualMachineReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The StorageVirtualMachineId of the StorageVirtualMachine resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStorageVirtualMachineId();

    /**
     * @return a {@link Builder} of {@link StorageVirtualMachineReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StorageVirtualMachineReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StorageVirtualMachineReference> {
        java.lang.String storageVirtualMachineId;

        /**
         * Sets the value of {@link StorageVirtualMachineReference#getStorageVirtualMachineId}
         * @param storageVirtualMachineId The StorageVirtualMachineId of the StorageVirtualMachine resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageVirtualMachineId(java.lang.String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StorageVirtualMachineReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StorageVirtualMachineReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StorageVirtualMachineReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageVirtualMachineReference {
        private final java.lang.String storageVirtualMachineId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageVirtualMachineId = software.amazon.jsii.Kernel.get(this, "storageVirtualMachineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageVirtualMachineId = java.util.Objects.requireNonNull(builder.storageVirtualMachineId, "storageVirtualMachineId is required");
        }

        @Override
        public final java.lang.String getStorageVirtualMachineId() {
            return this.storageVirtualMachineId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageVirtualMachineId", om.valueToTree(this.getStorageVirtualMachineId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_fsx.StorageVirtualMachineReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StorageVirtualMachineReference.Jsii$Proxy that = (StorageVirtualMachineReference.Jsii$Proxy) o;

            return this.storageVirtualMachineId.equals(that.storageVirtualMachineId);
        }

        @Override
        public final int hashCode() {
            int result = this.storageVirtualMachineId.hashCode();
            return result;
        }
    }
}
