package software.amazon.awscdk.interfaces.glue;

/**
 * A reference to a IntegrationResourceProperty resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.glue.*;
 * IntegrationResourcePropertyReference integrationResourcePropertyReference = IntegrationResourcePropertyReference.builder()
 *         .resourceArn("resourceArn")
 *         .resourcePropertyArn("resourcePropertyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.611Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_glue.IntegrationResourcePropertyReference")
@software.amazon.jsii.Jsii.Proxy(IntegrationResourcePropertyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationResourcePropertyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ResourceArn of the IntegrationResourceProperty resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * The ResourcePropertyArn of the IntegrationResourceProperty resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourcePropertyArn();

    /**
     * @return a {@link Builder} of {@link IntegrationResourcePropertyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationResourcePropertyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationResourcePropertyReference> {
        java.lang.String resourceArn;
        java.lang.String resourcePropertyArn;

        /**
         * Sets the value of {@link IntegrationResourcePropertyReference#getResourceArn}
         * @param resourceArn The ResourceArn of the IntegrationResourceProperty resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResourcePropertyReference#getResourcePropertyArn}
         * @param resourcePropertyArn The ResourcePropertyArn of the IntegrationResourceProperty resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePropertyArn(java.lang.String resourcePropertyArn) {
            this.resourcePropertyArn = resourcePropertyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationResourcePropertyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationResourcePropertyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationResourcePropertyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResourcePropertyReference {
        private final java.lang.String resourceArn;
        private final java.lang.String resourcePropertyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourcePropertyArn = software.amazon.jsii.Kernel.get(this, "resourcePropertyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.resourcePropertyArn = java.util.Objects.requireNonNull(builder.resourcePropertyArn, "resourcePropertyArn is required");
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.String getResourcePropertyArn() {
            return this.resourcePropertyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            data.set("resourcePropertyArn", om.valueToTree(this.getResourcePropertyArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_glue.IntegrationResourcePropertyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationResourcePropertyReference.Jsii$Proxy that = (IntegrationResourcePropertyReference.Jsii$Proxy) o;

            if (!resourceArn.equals(that.resourceArn)) return false;
            return this.resourcePropertyArn.equals(that.resourcePropertyArn);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceArn.hashCode();
            result = 31 * result + (this.resourcePropertyArn.hashCode());
            return result;
        }
    }
}
