package software.amazon.awscdk.interfaces.glue;

/**
 * A reference to a MLTransform resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.glue.*;
 * MLTransformReference mLTransformReference = MLTransformReference.builder()
 *         .mlTransformId("mlTransformId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_glue.MLTransformReference")
@software.amazon.jsii.Jsii.Proxy(MLTransformReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MLTransformReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the MLTransform resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMlTransformId();

    /**
     * @return a {@link Builder} of {@link MLTransformReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MLTransformReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MLTransformReference> {
        java.lang.String mlTransformId;

        /**
         * Sets the value of {@link MLTransformReference#getMlTransformId}
         * @param mlTransformId The Id of the MLTransform resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mlTransformId(java.lang.String mlTransformId) {
            this.mlTransformId = mlTransformId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MLTransformReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MLTransformReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MLTransformReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MLTransformReference {
        private final java.lang.String mlTransformId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mlTransformId = software.amazon.jsii.Kernel.get(this, "mlTransformId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mlTransformId = java.util.Objects.requireNonNull(builder.mlTransformId, "mlTransformId is required");
        }

        @Override
        public final java.lang.String getMlTransformId() {
            return this.mlTransformId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mlTransformId", om.valueToTree(this.getMlTransformId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_glue.MLTransformReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MLTransformReference.Jsii$Proxy that = (MLTransformReference.Jsii$Proxy) o;

            return this.mlTransformId.equals(that.mlTransformId);
        }

        @Override
        public final int hashCode() {
            int result = this.mlTransformId.hashCode();
            return result;
        }
    }
}
