package software.amazon.awscdk.interfaces.glue;

/**
 * A reference to a SchemaVersionMetadata resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.glue.*;
 * SchemaVersionMetadataReference schemaVersionMetadataReference = SchemaVersionMetadataReference.builder()
 *         .key("key")
 *         .schemaVersionId("schemaVersionId")
 *         .value("value")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.613Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_glue.SchemaVersionMetadataReference")
@software.amazon.jsii.Jsii.Proxy(SchemaVersionMetadataReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SchemaVersionMetadataReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Key of the SchemaVersionMetadata resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * The SchemaVersionId of the SchemaVersionMetadata resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaVersionId();

    /**
     * The Value of the SchemaVersionMetadata resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * @return a {@link Builder} of {@link SchemaVersionMetadataReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SchemaVersionMetadataReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SchemaVersionMetadataReference> {
        java.lang.String key;
        java.lang.String schemaVersionId;
        java.lang.String value;

        /**
         * Sets the value of {@link SchemaVersionMetadataReference#getKey}
         * @param key The Key of the SchemaVersionMetadata resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link SchemaVersionMetadataReference#getSchemaVersionId}
         * @param schemaVersionId The SchemaVersionId of the SchemaVersionMetadata resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersionId(java.lang.String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        /**
         * Sets the value of {@link SchemaVersionMetadataReference#getValue}
         * @param value The Value of the SchemaVersionMetadata resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SchemaVersionMetadataReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SchemaVersionMetadataReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SchemaVersionMetadataReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaVersionMetadataReference {
        private final java.lang.String key;
        private final java.lang.String schemaVersionId;
        private final java.lang.String value;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaVersionId = software.amazon.jsii.Kernel.get(this, "schemaVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.schemaVersionId = java.util.Objects.requireNonNull(builder.schemaVersionId, "schemaVersionId is required");
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("schemaVersionId", om.valueToTree(this.getSchemaVersionId()));
            data.set("value", om.valueToTree(this.getValue()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_glue.SchemaVersionMetadataReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SchemaVersionMetadataReference.Jsii$Proxy that = (SchemaVersionMetadataReference.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!schemaVersionId.equals(that.schemaVersionId)) return false;
            return this.value.equals(that.value);
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.schemaVersionId.hashCode());
            result = 31 * result + (this.value.hashCode());
            return result;
        }
    }
}
