package software.amazon.awscdk.interfaces.greengrass;

/**
 * A reference to a ConnectorDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.greengrass.*;
 * ConnectorDefinitionReference connectorDefinitionReference = ConnectorDefinitionReference.builder()
 *         .connectorDefinitionArn("connectorDefinitionArn")
 *         .connectorDefinitionId("connectorDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_greengrass.ConnectorDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(ConnectorDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectorDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ConnectorDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorDefinitionArn();

    /**
     * The Id of the ConnectorDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorDefinitionId();

    /**
     * @return a {@link Builder} of {@link ConnectorDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectorDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectorDefinitionReference> {
        java.lang.String connectorDefinitionArn;
        java.lang.String connectorDefinitionId;

        /**
         * Sets the value of {@link ConnectorDefinitionReference#getConnectorDefinitionArn}
         * @param connectorDefinitionArn The ARN of the ConnectorDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDefinitionArn(java.lang.String connectorDefinitionArn) {
            this.connectorDefinitionArn = connectorDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link ConnectorDefinitionReference#getConnectorDefinitionId}
         * @param connectorDefinitionId The Id of the ConnectorDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDefinitionId(java.lang.String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectorDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectorDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectorDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorDefinitionReference {
        private final java.lang.String connectorDefinitionArn;
        private final java.lang.String connectorDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectorDefinitionArn = software.amazon.jsii.Kernel.get(this, "connectorDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorDefinitionId = software.amazon.jsii.Kernel.get(this, "connectorDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectorDefinitionArn = java.util.Objects.requireNonNull(builder.connectorDefinitionArn, "connectorDefinitionArn is required");
            this.connectorDefinitionId = java.util.Objects.requireNonNull(builder.connectorDefinitionId, "connectorDefinitionId is required");
        }

        @Override
        public final java.lang.String getConnectorDefinitionArn() {
            return this.connectorDefinitionArn;
        }

        @Override
        public final java.lang.String getConnectorDefinitionId() {
            return this.connectorDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectorDefinitionArn", om.valueToTree(this.getConnectorDefinitionArn()));
            data.set("connectorDefinitionId", om.valueToTree(this.getConnectorDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_greengrass.ConnectorDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectorDefinitionReference.Jsii$Proxy that = (ConnectorDefinitionReference.Jsii$Proxy) o;

            if (!connectorDefinitionArn.equals(that.connectorDefinitionArn)) return false;
            return this.connectorDefinitionId.equals(that.connectorDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.connectorDefinitionArn.hashCode();
            result = 31 * result + (this.connectorDefinitionId.hashCode());
            return result;
        }
    }
}
