package software.amazon.awscdk.interfaces.greengrass;

/**
 * A reference to a SubscriptionDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.greengrass.*;
 * SubscriptionDefinitionReference subscriptionDefinitionReference = SubscriptionDefinitionReference.builder()
 *         .subscriptionDefinitionArn("subscriptionDefinitionArn")
 *         .subscriptionDefinitionId("subscriptionDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.625Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_greengrass.SubscriptionDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(SubscriptionDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SubscriptionDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionDefinitionArn();

    /**
     * The Id of the SubscriptionDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionDefinitionId();

    /**
     * @return a {@link Builder} of {@link SubscriptionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionDefinitionReference> {
        java.lang.String subscriptionDefinitionArn;
        java.lang.String subscriptionDefinitionId;

        /**
         * Sets the value of {@link SubscriptionDefinitionReference#getSubscriptionDefinitionArn}
         * @param subscriptionDefinitionArn The ARN of the SubscriptionDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionDefinitionArn(java.lang.String subscriptionDefinitionArn) {
            this.subscriptionDefinitionArn = subscriptionDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionDefinitionReference#getSubscriptionDefinitionId}
         * @param subscriptionDefinitionId The Id of the SubscriptionDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionDefinitionId(java.lang.String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriptionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionDefinitionReference {
        private final java.lang.String subscriptionDefinitionArn;
        private final java.lang.String subscriptionDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subscriptionDefinitionArn = software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionDefinitionId = software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subscriptionDefinitionArn = java.util.Objects.requireNonNull(builder.subscriptionDefinitionArn, "subscriptionDefinitionArn is required");
            this.subscriptionDefinitionId = java.util.Objects.requireNonNull(builder.subscriptionDefinitionId, "subscriptionDefinitionId is required");
        }

        @Override
        public final java.lang.String getSubscriptionDefinitionArn() {
            return this.subscriptionDefinitionArn;
        }

        @Override
        public final java.lang.String getSubscriptionDefinitionId() {
            return this.subscriptionDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subscriptionDefinitionArn", om.valueToTree(this.getSubscriptionDefinitionArn()));
            data.set("subscriptionDefinitionId", om.valueToTree(this.getSubscriptionDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_greengrass.SubscriptionDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionDefinitionReference.Jsii$Proxy that = (SubscriptionDefinitionReference.Jsii$Proxy) o;

            if (!subscriptionDefinitionArn.equals(that.subscriptionDefinitionArn)) return false;
            return this.subscriptionDefinitionId.equals(that.subscriptionDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.subscriptionDefinitionArn.hashCode();
            result = 31 * result + (this.subscriptionDefinitionId.hashCode());
            return result;
        }
    }
}
