package software.amazon.awscdk.interfaces.greengrassv2;

/**
 * A reference to a ComponentVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.greengrassv2.*;
 * ComponentVersionReference componentVersionReference = ComponentVersionReference.builder()
 *         .componentVersionArn("componentVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.626Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_greengrassv2.ComponentVersionReference")
@software.amazon.jsii.Jsii.Proxy(ComponentVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComponentVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ComponentVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComponentVersionArn();

    /**
     * @return a {@link Builder} of {@link ComponentVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComponentVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComponentVersionReference> {
        java.lang.String componentVersionArn;

        /**
         * Sets the value of {@link ComponentVersionReference#getComponentVersionArn}
         * @param componentVersionArn The Arn of the ComponentVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentVersionArn(java.lang.String componentVersionArn) {
            this.componentVersionArn = componentVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComponentVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComponentVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComponentVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentVersionReference {
        private final java.lang.String componentVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.componentVersionArn = software.amazon.jsii.Kernel.get(this, "componentVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.componentVersionArn = java.util.Objects.requireNonNull(builder.componentVersionArn, "componentVersionArn is required");
        }

        @Override
        public final java.lang.String getComponentVersionArn() {
            return this.componentVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("componentVersionArn", om.valueToTree(this.getComponentVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_greengrassv2.ComponentVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComponentVersionReference.Jsii$Proxy that = (ComponentVersionReference.Jsii$Proxy) o;

            return this.componentVersionArn.equals(that.componentVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.componentVersionArn.hashCode();
            return result;
        }
    }
}
