package software.amazon.awscdk.interfaces.iam;

/**
 * A reference to a ServerCertificate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iam.*;
 * ServerCertificateReference serverCertificateReference = ServerCertificateReference.builder()
 *         .serverCertificateArn("serverCertificateArn")
 *         .serverCertificateName("serverCertificateName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.657Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iam.ServerCertificateReference")
@software.amazon.jsii.Jsii.Proxy(ServerCertificateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerCertificateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ServerCertificate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateArn();

    /**
     * The ServerCertificateName of the ServerCertificate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateName();

    /**
     * @return a {@link Builder} of {@link ServerCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateReference> {
        java.lang.String serverCertificateArn;
        java.lang.String serverCertificateName;

        /**
         * Sets the value of {@link ServerCertificateReference#getServerCertificateArn}
         * @param serverCertificateArn The ARN of the ServerCertificate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link ServerCertificateReference#getServerCertificateName}
         * @param serverCertificateName The ServerCertificateName of the ServerCertificate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateName(java.lang.String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerCertificateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerCertificateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateReference {
        private final java.lang.String serverCertificateArn;
        private final java.lang.String serverCertificateName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serverCertificateArn = software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverCertificateName = software.amazon.jsii.Kernel.get(this, "serverCertificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serverCertificateArn = java.util.Objects.requireNonNull(builder.serverCertificateArn, "serverCertificateArn is required");
            this.serverCertificateName = java.util.Objects.requireNonNull(builder.serverCertificateName, "serverCertificateName is required");
        }

        @Override
        public final java.lang.String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final java.lang.String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
            data.set("serverCertificateName", om.valueToTree(this.getServerCertificateName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iam.ServerCertificateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerCertificateReference.Jsii$Proxy that = (ServerCertificateReference.Jsii$Proxy) o;

            if (!serverCertificateArn.equals(that.serverCertificateArn)) return false;
            return this.serverCertificateName.equals(that.serverCertificateName);
        }

        @Override
        public final int hashCode() {
            int result = this.serverCertificateArn.hashCode();
            result = 31 * result + (this.serverCertificateName.hashCode());
            return result;
        }
    }
}
