package software.amazon.awscdk.interfaces.inspector;

/**
 * A reference to a AssessmentTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.inspector.*;
 * AssessmentTemplateReference assessmentTemplateReference = AssessmentTemplateReference.builder()
 *         .assessmentTemplateArn("assessmentTemplateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.665Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_inspector.AssessmentTemplateReference")
@software.amazon.jsii.Jsii.Proxy(AssessmentTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssessmentTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the AssessmentTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssessmentTemplateArn();

    /**
     * @return a {@link Builder} of {@link AssessmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssessmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssessmentTemplateReference> {
        java.lang.String assessmentTemplateArn;

        /**
         * Sets the value of {@link AssessmentTemplateReference#getAssessmentTemplateArn}
         * @param assessmentTemplateArn The Arn of the AssessmentTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentTemplateArn(java.lang.String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssessmentTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssessmentTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssessmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssessmentTemplateReference {
        private final java.lang.String assessmentTemplateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assessmentTemplateArn = software.amazon.jsii.Kernel.get(this, "assessmentTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assessmentTemplateArn = java.util.Objects.requireNonNull(builder.assessmentTemplateArn, "assessmentTemplateArn is required");
        }

        @Override
        public final java.lang.String getAssessmentTemplateArn() {
            return this.assessmentTemplateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assessmentTemplateArn", om.valueToTree(this.getAssessmentTemplateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_inspector.AssessmentTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssessmentTemplateReference.Jsii$Proxy that = (AssessmentTemplateReference.Jsii$Proxy) o;

            return this.assessmentTemplateArn.equals(that.assessmentTemplateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.assessmentTemplateArn.hashCode();
            return result;
        }
    }
}
