package software.amazon.awscdk.interfaces.internetmonitor;

/**
 * A reference to a Monitor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.internetmonitor.*;
 * MonitorReference monitorReference = MonitorReference.builder()
 *         .monitorArn("monitorArn")
 *         .monitorName("monitorName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.670Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_internetmonitor.MonitorReference")
@software.amazon.jsii.Jsii.Proxy(MonitorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MonitorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Monitor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitorArn();

    /**
     * The MonitorName of the Monitor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitorName();

    /**
     * @return a {@link Builder} of {@link MonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MonitorReference> {
        java.lang.String monitorArn;
        java.lang.String monitorName;

        /**
         * Sets the value of {@link MonitorReference#getMonitorArn}
         * @param monitorArn The ARN of the Monitor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorArn(java.lang.String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        /**
         * Sets the value of {@link MonitorReference#getMonitorName}
         * @param monitorName The MonitorName of the Monitor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorName(java.lang.String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MonitorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MonitorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitorReference {
        private final java.lang.String monitorArn;
        private final java.lang.String monitorName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.monitorArn = software.amazon.jsii.Kernel.get(this, "monitorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitorName = software.amazon.jsii.Kernel.get(this, "monitorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.monitorArn = java.util.Objects.requireNonNull(builder.monitorArn, "monitorArn is required");
            this.monitorName = java.util.Objects.requireNonNull(builder.monitorName, "monitorName is required");
        }

        @Override
        public final java.lang.String getMonitorArn() {
            return this.monitorArn;
        }

        @Override
        public final java.lang.String getMonitorName() {
            return this.monitorName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("monitorArn", om.valueToTree(this.getMonitorArn()));
            data.set("monitorName", om.valueToTree(this.getMonitorName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_internetmonitor.MonitorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MonitorReference.Jsii$Proxy that = (MonitorReference.Jsii$Proxy) o;

            if (!monitorArn.equals(that.monitorArn)) return false;
            return this.monitorName.equals(that.monitorName);
        }

        @Override
        public final int hashCode() {
            int result = this.monitorArn.hashCode();
            result = 31 * result + (this.monitorName.hashCode());
            return result;
        }
    }
}
