package software.amazon.awscdk.interfaces.iot;

/**
 * A reference to a DomainConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iot.*;
 * DomainConfigurationReference domainConfigurationReference = DomainConfigurationReference.builder()
 *         .domainConfigurationArn("domainConfigurationArn")
 *         .domainConfigurationName("domainConfigurationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.673Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iot.DomainConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(DomainConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DomainConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainConfigurationArn();

    /**
     * The DomainConfigurationName of the DomainConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainConfigurationName();

    /**
     * @return a {@link Builder} of {@link DomainConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainConfigurationReference> {
        java.lang.String domainConfigurationArn;
        java.lang.String domainConfigurationName;

        /**
         * Sets the value of {@link DomainConfigurationReference#getDomainConfigurationArn}
         * @param domainConfigurationArn The ARN of the DomainConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationArn(java.lang.String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link DomainConfigurationReference#getDomainConfigurationName}
         * @param domainConfigurationName The DomainConfigurationName of the DomainConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationName(java.lang.String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainConfigurationReference {
        private final java.lang.String domainConfigurationArn;
        private final java.lang.String domainConfigurationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainConfigurationArn = software.amazon.jsii.Kernel.get(this, "domainConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainConfigurationName = software.amazon.jsii.Kernel.get(this, "domainConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainConfigurationArn = java.util.Objects.requireNonNull(builder.domainConfigurationArn, "domainConfigurationArn is required");
            this.domainConfigurationName = java.util.Objects.requireNonNull(builder.domainConfigurationName, "domainConfigurationName is required");
        }

        @Override
        public final java.lang.String getDomainConfigurationArn() {
            return this.domainConfigurationArn;
        }

        @Override
        public final java.lang.String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainConfigurationArn", om.valueToTree(this.getDomainConfigurationArn()));
            data.set("domainConfigurationName", om.valueToTree(this.getDomainConfigurationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iot.DomainConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainConfigurationReference.Jsii$Proxy that = (DomainConfigurationReference.Jsii$Proxy) o;

            if (!domainConfigurationArn.equals(that.domainConfigurationArn)) return false;
            return this.domainConfigurationName.equals(that.domainConfigurationName);
        }

        @Override
        public final int hashCode() {
            int result = this.domainConfigurationArn.hashCode();
            result = 31 * result + (this.domainConfigurationName.hashCode());
            return result;
        }
    }
}
