package software.amazon.awscdk.interfaces.iot;

/**
 * A reference to a ScheduledAudit resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iot.*;
 * ScheduledAuditReference scheduledAuditReference = ScheduledAuditReference.builder()
 *         .scheduledAuditArn("scheduledAuditArn")
 *         .scheduledAuditName("scheduledAuditName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.697Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iot.ScheduledAuditReference")
@software.amazon.jsii.Jsii.Proxy(ScheduledAuditReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledAuditReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ScheduledAudit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduledAuditArn();

    /**
     * The ScheduledAuditName of the ScheduledAudit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduledAuditName();

    /**
     * @return a {@link Builder} of {@link ScheduledAuditReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledAuditReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledAuditReference> {
        java.lang.String scheduledAuditArn;
        java.lang.String scheduledAuditName;

        /**
         * Sets the value of {@link ScheduledAuditReference#getScheduledAuditArn}
         * @param scheduledAuditArn The ARN of the ScheduledAudit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledAuditArn(java.lang.String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledAuditReference#getScheduledAuditName}
         * @param scheduledAuditName The ScheduledAuditName of the ScheduledAudit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledAuditName(java.lang.String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledAuditReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledAuditReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledAuditReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledAuditReference {
        private final java.lang.String scheduledAuditArn;
        private final java.lang.String scheduledAuditName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scheduledAuditArn = software.amazon.jsii.Kernel.get(this, "scheduledAuditArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduledAuditName = software.amazon.jsii.Kernel.get(this, "scheduledAuditName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scheduledAuditArn = java.util.Objects.requireNonNull(builder.scheduledAuditArn, "scheduledAuditArn is required");
            this.scheduledAuditName = java.util.Objects.requireNonNull(builder.scheduledAuditName, "scheduledAuditName is required");
        }

        @Override
        public final java.lang.String getScheduledAuditArn() {
            return this.scheduledAuditArn;
        }

        @Override
        public final java.lang.String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scheduledAuditArn", om.valueToTree(this.getScheduledAuditArn()));
            data.set("scheduledAuditName", om.valueToTree(this.getScheduledAuditName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iot.ScheduledAuditReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledAuditReference.Jsii$Proxy that = (ScheduledAuditReference.Jsii$Proxy) o;

            if (!scheduledAuditArn.equals(that.scheduledAuditArn)) return false;
            return this.scheduledAuditName.equals(that.scheduledAuditName);
        }

        @Override
        public final int hashCode() {
            int result = this.scheduledAuditArn.hashCode();
            result = 31 * result + (this.scheduledAuditName.hashCode());
            return result;
        }
    }
}
