package software.amazon.awscdk.interfaces.iot;

/**
 * A reference to a ThingType resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iot.*;
 * ThingTypeReference thingTypeReference = ThingTypeReference.builder()
 *         .thingTypeArn("thingTypeArn")
 *         .thingTypeName("thingTypeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.699Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iot.ThingTypeReference")
@software.amazon.jsii.Jsii.Proxy(ThingTypeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThingTypeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ThingType resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingTypeArn();

    /**
     * The ThingTypeName of the ThingType resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingTypeName();

    /**
     * @return a {@link Builder} of {@link ThingTypeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThingTypeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThingTypeReference> {
        java.lang.String thingTypeArn;
        java.lang.String thingTypeName;

        /**
         * Sets the value of {@link ThingTypeReference#getThingTypeArn}
         * @param thingTypeArn The ARN of the ThingType resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeArn(java.lang.String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
            return this;
        }

        /**
         * Sets the value of {@link ThingTypeReference#getThingTypeName}
         * @param thingTypeName The ThingTypeName of the ThingType resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeName(java.lang.String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThingTypeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThingTypeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThingTypeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThingTypeReference {
        private final java.lang.String thingTypeArn;
        private final java.lang.String thingTypeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.thingTypeArn = software.amazon.jsii.Kernel.get(this, "thingTypeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingTypeName = software.amazon.jsii.Kernel.get(this, "thingTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.thingTypeArn = java.util.Objects.requireNonNull(builder.thingTypeArn, "thingTypeArn is required");
            this.thingTypeName = java.util.Objects.requireNonNull(builder.thingTypeName, "thingTypeName is required");
        }

        @Override
        public final java.lang.String getThingTypeArn() {
            return this.thingTypeArn;
        }

        @Override
        public final java.lang.String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("thingTypeArn", om.valueToTree(this.getThingTypeArn()));
            data.set("thingTypeName", om.valueToTree(this.getThingTypeName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iot.ThingTypeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThingTypeReference.Jsii$Proxy that = (ThingTypeReference.Jsii$Proxy) o;

            if (!thingTypeArn.equals(that.thingTypeArn)) return false;
            return this.thingTypeName.equals(that.thingTypeName);
        }

        @Override
        public final int hashCode() {
            int result = this.thingTypeArn.hashCode();
            result = 31 * result + (this.thingTypeName.hashCode());
            return result;
        }
    }
}
