package software.amazon.awscdk.interfaces.iotfleetwise;

/**
 * A reference to a StateTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotfleetwise.*;
 * StateTemplateReference stateTemplateReference = StateTemplateReference.builder()
 *         .stateTemplateArn("stateTemplateArn")
 *         .stateTemplateName("stateTemplateName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.709Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotfleetwise.StateTemplateReference")
@software.amazon.jsii.Jsii.Proxy(StateTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the StateTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStateTemplateArn();

    /**
     * The Name of the StateTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStateTemplateName();

    /**
     * @return a {@link Builder} of {@link StateTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateTemplateReference> {
        java.lang.String stateTemplateArn;
        java.lang.String stateTemplateName;

        /**
         * Sets the value of {@link StateTemplateReference#getStateTemplateArn}
         * @param stateTemplateArn The ARN of the StateTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplateArn(java.lang.String stateTemplateArn) {
            this.stateTemplateArn = stateTemplateArn;
            return this;
        }

        /**
         * Sets the value of {@link StateTemplateReference#getStateTemplateName}
         * @param stateTemplateName The Name of the StateTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplateName(java.lang.String stateTemplateName) {
            this.stateTemplateName = stateTemplateName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateTemplateReference {
        private final java.lang.String stateTemplateArn;
        private final java.lang.String stateTemplateName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateTemplateArn = software.amazon.jsii.Kernel.get(this, "stateTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateTemplateName = software.amazon.jsii.Kernel.get(this, "stateTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateTemplateArn = java.util.Objects.requireNonNull(builder.stateTemplateArn, "stateTemplateArn is required");
            this.stateTemplateName = java.util.Objects.requireNonNull(builder.stateTemplateName, "stateTemplateName is required");
        }

        @Override
        public final java.lang.String getStateTemplateArn() {
            return this.stateTemplateArn;
        }

        @Override
        public final java.lang.String getStateTemplateName() {
            return this.stateTemplateName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateTemplateArn", om.valueToTree(this.getStateTemplateArn()));
            data.set("stateTemplateName", om.valueToTree(this.getStateTemplateName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotfleetwise.StateTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateTemplateReference.Jsii$Proxy that = (StateTemplateReference.Jsii$Proxy) o;

            if (!stateTemplateArn.equals(that.stateTemplateArn)) return false;
            return this.stateTemplateName.equals(that.stateTemplateName);
        }

        @Override
        public final int hashCode() {
            int result = this.stateTemplateArn.hashCode();
            result = 31 * result + (this.stateTemplateName.hashCode());
            return result;
        }
    }
}
