package software.amazon.awscdk.interfaces.iotsitewise;

/**
 * A reference to a AssetModel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotsitewise.*;
 * AssetModelReference assetModelReference = AssetModelReference.builder()
 *         .assetModelArn("assetModelArn")
 *         .assetModelId("assetModelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.710Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotsitewise.AssetModelReference")
@software.amazon.jsii.Jsii.Proxy(AssetModelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetModelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AssetModel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetModelArn();

    /**
     * The AssetModelId of the AssetModel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetModelId();

    /**
     * @return a {@link Builder} of {@link AssetModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetModelReference> {
        java.lang.String assetModelArn;
        java.lang.String assetModelId;

        /**
         * Sets the value of {@link AssetModelReference#getAssetModelArn}
         * @param assetModelArn The ARN of the AssetModel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelArn(java.lang.String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        /**
         * Sets the value of {@link AssetModelReference#getAssetModelId}
         * @param assetModelId The AssetModelId of the AssetModel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelId(java.lang.String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetModelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetModelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetModelReference {
        private final java.lang.String assetModelArn;
        private final java.lang.String assetModelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetModelArn = software.amazon.jsii.Kernel.get(this, "assetModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetModelId = software.amazon.jsii.Kernel.get(this, "assetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetModelArn = java.util.Objects.requireNonNull(builder.assetModelArn, "assetModelArn is required");
            this.assetModelId = java.util.Objects.requireNonNull(builder.assetModelId, "assetModelId is required");
        }

        @Override
        public final java.lang.String getAssetModelArn() {
            return this.assetModelArn;
        }

        @Override
        public final java.lang.String getAssetModelId() {
            return this.assetModelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assetModelArn", om.valueToTree(this.getAssetModelArn()));
            data.set("assetModelId", om.valueToTree(this.getAssetModelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotsitewise.AssetModelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetModelReference.Jsii$Proxy that = (AssetModelReference.Jsii$Proxy) o;

            if (!assetModelArn.equals(that.assetModelArn)) return false;
            return this.assetModelId.equals(that.assetModelId);
        }

        @Override
        public final int hashCode() {
            int result = this.assetModelArn.hashCode();
            result = 31 * result + (this.assetModelId.hashCode());
            return result;
        }
    }
}
