package software.amazon.awscdk.interfaces.iotthingsgraph;

/**
 * A reference to a FlowTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotthingsgraph.*;
 * FlowTemplateReference flowTemplateReference = FlowTemplateReference.builder()
 *         .flowTemplateId("flowTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.726Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotthingsgraph.FlowTemplateReference")
@software.amazon.jsii.Jsii.Proxy(FlowTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FlowTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the FlowTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowTemplateId();

    /**
     * @return a {@link Builder} of {@link FlowTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FlowTemplateReference> {
        java.lang.String flowTemplateId;

        /**
         * Sets the value of {@link FlowTemplateReference#getFlowTemplateId}
         * @param flowTemplateId The Id of the FlowTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowTemplateId(java.lang.String flowTemplateId) {
            this.flowTemplateId = flowTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FlowTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FlowTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowTemplateReference {
        private final java.lang.String flowTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flowTemplateId = software.amazon.jsii.Kernel.get(this, "flowTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flowTemplateId = java.util.Objects.requireNonNull(builder.flowTemplateId, "flowTemplateId is required");
        }

        @Override
        public final java.lang.String getFlowTemplateId() {
            return this.flowTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flowTemplateId", om.valueToTree(this.getFlowTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotthingsgraph.FlowTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowTemplateReference.Jsii$Proxy that = (FlowTemplateReference.Jsii$Proxy) o;

            return this.flowTemplateId.equals(that.flowTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.flowTemplateId.hashCode();
            return result;
        }
    }
}
