package software.amazon.awscdk.interfaces.iotwireless;

/**
 * A reference to a FuotaTask resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotwireless.*;
 * FuotaTaskReference fuotaTaskReference = FuotaTaskReference.builder()
 *         .fuotaTaskArn("fuotaTaskArn")
 *         .fuotaTaskId("fuotaTaskId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.731Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotwireless.FuotaTaskReference")
@software.amazon.jsii.Jsii.Proxy(FuotaTaskReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FuotaTaskReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the FuotaTask resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFuotaTaskArn();

    /**
     * The Id of the FuotaTask resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFuotaTaskId();

    /**
     * @return a {@link Builder} of {@link FuotaTaskReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FuotaTaskReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FuotaTaskReference> {
        java.lang.String fuotaTaskArn;
        java.lang.String fuotaTaskId;

        /**
         * Sets the value of {@link FuotaTaskReference#getFuotaTaskArn}
         * @param fuotaTaskArn The ARN of the FuotaTask resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fuotaTaskArn(java.lang.String fuotaTaskArn) {
            this.fuotaTaskArn = fuotaTaskArn;
            return this;
        }

        /**
         * Sets the value of {@link FuotaTaskReference#getFuotaTaskId}
         * @param fuotaTaskId The Id of the FuotaTask resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fuotaTaskId(java.lang.String fuotaTaskId) {
            this.fuotaTaskId = fuotaTaskId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FuotaTaskReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FuotaTaskReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FuotaTaskReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FuotaTaskReference {
        private final java.lang.String fuotaTaskArn;
        private final java.lang.String fuotaTaskId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fuotaTaskArn = software.amazon.jsii.Kernel.get(this, "fuotaTaskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fuotaTaskId = software.amazon.jsii.Kernel.get(this, "fuotaTaskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fuotaTaskArn = java.util.Objects.requireNonNull(builder.fuotaTaskArn, "fuotaTaskArn is required");
            this.fuotaTaskId = java.util.Objects.requireNonNull(builder.fuotaTaskId, "fuotaTaskId is required");
        }

        @Override
        public final java.lang.String getFuotaTaskArn() {
            return this.fuotaTaskArn;
        }

        @Override
        public final java.lang.String getFuotaTaskId() {
            return this.fuotaTaskId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fuotaTaskArn", om.valueToTree(this.getFuotaTaskArn()));
            data.set("fuotaTaskId", om.valueToTree(this.getFuotaTaskId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotwireless.FuotaTaskReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FuotaTaskReference.Jsii$Proxy that = (FuotaTaskReference.Jsii$Proxy) o;

            if (!fuotaTaskArn.equals(that.fuotaTaskArn)) return false;
            return this.fuotaTaskId.equals(that.fuotaTaskId);
        }

        @Override
        public final int hashCode() {
            int result = this.fuotaTaskArn.hashCode();
            result = 31 * result + (this.fuotaTaskId.hashCode());
            return result;
        }
    }
}
